# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' pmf for zero-inflated poisson
#' @param p proportion of structural zero's
#' @param theta the poisson mean
#' @param y the observed value
#' @param loga Logical. Whether to return the log probability or not.
#' @return the probability mass of the zero-inflated poisson distribution
#' @export
dzip <- function(p, theta, y, loga) {
    .Call('ziphsmm_dzip', PACKAGE = 'ziphsmm', p, theta, y, loga)
}

#' generate zero-inflated poisson random variables
#' @param n length of the random series
#' @param p proportion of structural zero's
#' @param theta the poisson mean
#' @return a series of zero-inflated poisson random variables
#' @export
rzip <- function(n, p, theta) {
    .Call('ziphsmm_rzip', PACKAGE = 'ziphsmm', n, p, theta)
}

rshiftpois <- function(n, theta, shift) {
    .Call('ziphsmm_rshiftpois', PACKAGE = 'ziphsmm', n, theta, shift)
}

dshiftpois <- function(x, theta, shift, loga) {
    .Call('ziphsmm_dshiftpois', PACKAGE = 'ziphsmm', x, theta, shift, loga)
}

dlogp <- function(x, p, loga) {
    .Call('ziphsmm_dlogp', PACKAGE = 'ziphsmm', x, p, loga)
}

rlogp <- function(n, p) {
    .Call('ziphsmm_rlogp', PACKAGE = 'ziphsmm', n, p)
}

multinomrand <- function(n, k, prob, label) {
    .Call('ziphsmm_multinomrand', PACKAGE = 'ziphsmm', n, k, prob, label)
}

hsmm_hmm <- function(omega, dm, mv) {
    .Call('ziphsmm_hsmm_hmm', PACKAGE = 'ziphsmm', omega, dm, mv)
}

hmm_gen <- function(dim, M, ntimes, pi, a, theta, zeroprop) {
    .Call('ziphsmm_hmm_gen', PACKAGE = 'ziphsmm', dim, M, ntimes, pi, a, theta, zeroprop)
}

hsmm_gen <- function(dim, M, pi, theta, zeroprop, omega, p, dt_dist) {
    .Call('ziphsmm_hsmm_gen', PACKAGE = 'ziphsmm', dim, M, pi, theta, zeroprop, omega, p, dt_dist)
}

hmm_nllk <- function(parm, M, y, zeroindex) {
    .Call('ziphsmm_hmm_nllk', PACKAGE = 'ziphsmm', parm, M, y, zeroindex)
}

hmm_common_nocov_negloglik <- function(allparm, M, ally, ntimes, zeroindex) {
    .Call('ziphsmm_hmm_common_nocov_negloglik', PACKAGE = 'ziphsmm', allparm, M, ally, ntimes, zeroindex)
}

hmm_cov_negloglik <- function(parm, M, y, ncolcovpi, covpi, ncolcovtrans, covtrans, ncolcovp1, covp1, ncolcovpois, covpois, zeroindex) {
    .Call('ziphsmm_hmm_cov_negloglik', PACKAGE = 'ziphsmm', parm, M, y, ncolcovpi, covpi, ncolcovtrans, covtrans, ncolcovp1, covp1, ncolcovpois, covpois, zeroindex)
}

hmm_common_negloglik <- function(allparm, M, ally, ntimes, ncolcovpi, allcovpi, ncolcovtrans, allcovtrans, ncolcovp1, allcovp1, ncolcovpois, allcovpois, zeroindex) {
    .Call('ziphsmm_hmm_common_negloglik', PACKAGE = 'ziphsmm', allparm, M, ally, ntimes, ncolcovpi, allcovpi, ncolcovtrans, allcovtrans, ncolcovp1, allcovp1, ncolcovpois, allcovpois, zeroindex)
}

hmm_mixed_negloglik <- function(allparm, M, ally, ntimes, ncolcovpi, allcovpi, ncolcovtrans, allcovtrans, ncolcovp1, allcovp1, ncolcovpois, allcovpois, nrand, B, zeroindex) {
    .Call('ziphsmm_hmm_mixed_negloglik', PACKAGE = 'ziphsmm', allparm, M, ally, ntimes, ncolcovpi, allcovpi, ncolcovtrans, allcovtrans, ncolcovp1, allcovp1, ncolcovpois, allcovpois, nrand, B, zeroindex)
}

hsmm_nllk <- function(parm, M, trunc, y, dt_dist, zeroindex) {
    .Call('ziphsmm_hsmm_nllk', PACKAGE = 'ziphsmm', parm, M, trunc, y, dt_dist, zeroindex)
}

hsmm_common_nocov_nllk <- function(allparm, M, ally, trunc, ntimes, dt_dist, zeroprop) {
    .Call('ziphsmm_hsmm_common_nocov_nllk', PACKAGE = 'ziphsmm', allparm, M, ally, trunc, ntimes, dt_dist, zeroprop)
}

hsmm_cov_nllk <- function(parm, M, y, trunc, dt_dist, zeroindex, ncolcovp, covp, ncolcovpi, covpi, ncolcovomega, covomega, ncolcovp1, covp1, ncolcovpois, covpois) {
    .Call('ziphsmm_hsmm_cov_nllk', PACKAGE = 'ziphsmm', parm, M, y, trunc, dt_dist, zeroindex, ncolcovp, covp, ncolcovpi, covpi, ncolcovomega, covomega, ncolcovp1, covp1, ncolcovpois, covpois)
}

hsmm_common_negloglik <- function(allparm, M, ally, trunc, ntimes, dt_dist, zeroindex, ncolcovp, allcovp, ncolcovpi, allcovpi, ncolcovomega, allcovomega, ncolcovp1, allcovp1, ncolcovpois, allcovpois) {
    .Call('ziphsmm_hsmm_common_negloglik', PACKAGE = 'ziphsmm', allparm, M, ally, trunc, ntimes, dt_dist, zeroindex, ncolcovp, allcovp, ncolcovpi, allcovpi, ncolcovomega, allcovomega, ncolcovp1, allcovp1, ncolcovpois, allcovpois)
}

hmm_viterbi <- function(pi, a, theta, M, y, zeroprop) {
    .Call('ziphsmm_hmm_viterbi', PACKAGE = 'ziphsmm', pi, a, theta, M, y, zeroprop)
}

hsmm_viterbi <- function(y, M, pi, theta, omega, p, trunc, dt_dist, zeroprop) {
    .Call('ziphsmm_hsmm_viterbi', PACKAGE = 'ziphsmm', y, M, pi, theta, omega, p, trunc, dt_dist, zeroprop)
}

hmm_cov_viterbi <- function(parm, M, y, ncolcovpi, covpi, ncolcovtrans, covtrans, ncolcovp1, covp1, ncolcovpois, covpois, zeroindex) {
    .Call('ziphsmm_hmm_cov_viterbi', PACKAGE = 'ziphsmm', parm, M, y, ncolcovpi, covpi, ncolcovtrans, covtrans, ncolcovp1, covp1, ncolcovpois, covpois, zeroindex)
}

hsmm_cov_viterbi <- function(parm, M, y, trunc, zeroindex, ncolcovp, covp, ncolcovpi, covpi, ncolcovomega, covomega, ncolcovp1, covp1, ncolcovpois, covpois, dt_dist) {
    .Call('ziphsmm_hsmm_cov_viterbi', PACKAGE = 'ziphsmm', parm, M, y, trunc, zeroindex, ncolcovp, covp, ncolcovpi, covpi, ncolcovomega, covomega, ncolcovp1, covp1, ncolcovpois, covpois, dt_dist)
}

