% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/zvariant-methods.R
\name{save_zvariant}
\alias{save_zvariant}
\alias{save_zvariant,Zvariant-method}
\title{Saves the current state of an instance of \code{\link{Zvariant-class}} on
the file system. \code{Zvariant} object tracks the location of relevant
files, but the root path can be changed. If it is not changed, then the
current files can be overwritten.}
\usage{
save_zvariant(x, dir = "", overwrite = FALSE, debug_msg = FALSE)

\S4method{save_zvariant}{Zvariant}(x, dir = "", overwrite = FALSE, debug_msg = FALSE)
}
\arguments{
\item{x}{Zvariant object.}

\item{dir}{Character string path to the root directory where the variant
is created.}

\item{overwrite}{Logical indicating whether files should overwritten if
they exist.}

\item{debug_msg}{Logical setting whether extra debugging information should be
printed.}
}
\value{
Invisible NULL. This method is used only for it's side effects.
}
\description{
Saves the current state of an instance of \code{\link{Zvariant-class}} on
the file system. \code{Zvariant} object tracks the location of relevant
files, but the root path can be changed. If it is not changed, then the
current files can be overwritten.
}
\seealso{
\code{\link{Zvariant-class}}
}
\author{
Joona Lehtomaki \email{joona.lehtomaki@gmail.com}
}
