% Generated by roxygen2 (4.0.2): do not edit by hand
\name{update_ztable}
\alias{update_ztable}
\title{Update ztable before print}
\usage{
update_ztable(z, size = NULL, color = NULL, tablewidth = NULL,
  type = NULL, include.rownames = NULL, placement = NULL,
  position = NULL, show.heading = NULL, show.footer = NULL,
  caption = NULL, caption.placement = NULL, caption.position = NULL,
  caption.bold = NULL, align = NULL, digits = NULL, display = NULL,
  sidewaystable = NULL, longtable = NULL, rotate = NULL, turn = NULL,
  angle = NULL, wraptable = NULL, wraptablewidth = NULL, tabular = NULL,
  label = NULL, hline.after = NULL, booktabs = NULL, prefix.rows = NULL,
  commands = NULL, top.command = NULL, zebra = NULL, zebra.color = NULL,
  zebra.type = NULL, zebra.list = NULL, zebra.colnames = NULL,
  zebra.rownames = NULL, colnames.bold = NULL, include.colnames = NULL,
  cgroup = NULL, n.cgroup = NULL, rgroup = NULL, n.rgroup = NULL,
  cspan.rgroup = NULL)
}
\arguments{
\item{z}{An object of class "ztable"}

\item{size}{An integer from 1 to 10 indicating font size= c("tiny","scriptsize",
"footnotesize","small","normalsize","large","Large","LARGE","huge","Huge")
respectively.}

\item{color}{A character indicating color of ztable}

\item{tablewidth}{A numeric indicating desired table width as a ratio to linewidth.
Default value is 0.3.}

\item{type}{character indicating formats of ztable, either "html" or "latex".}

\item{include.rownames}{A logical value whether or not include rownames in the table}

\item{placement}{The table will have placement given by placement where placement
must be NULL or contain only elements of {"h","t","b","p","!","H"}.}

\item{position}{The table will be have placed at the center of the paper
if position is "center" or "c", and at the left side of the paper
if it equals "left" or "l", and at the right side of the paper
if it equals "right" or "r". The position is translated to specificed
latex environments such as "flushright" or "flushleft" or "center"
(provided as a character vector) will enclose the tabular environment.}

\item{show.heading}{A logical value whether or not include headings in the table.}

\item{show.footer}{A logical value whether or not include headings in the table.}

\item{caption}{A character}

\item{caption.placement}{The caption will be have placed at the top of the table
if caption.placement is "top" and at the bottom of the table
if it equals "bottom".}

\item{caption.position}{The caption will be have placed at the center of the table
if caption.position is "center" or "c", and at the left side of the table
if it equals "left" or "l", and at the right side of the table
if it equals "right" or "r".}

\item{caption.bold}{whether or not use bold font for caption}

\item{align}{Character vector : nchar equal to the number of columns of the
resulting table indicating the alignment of the corresponding columns.}

\item{digits}{Numeric vector of length equal to one (in which case it will be
replicated as necessary) or to the number of columns of the resulting table}

\item{display}{Character vector of length equal to the number of columns of the
resulting table indicating the format for the corresponding columns.
Since the row names are printed in the first column, the length of display
is one greater than ncol(x) if x is a data.frame. These values are passed
to the formatC function. Use "d" (for integers), "f", "e", "E", "g", "G",
"fg" (for reals), or "s" (for strings). "f" gives numbers in the usual
xxx.xxx format; "e" and "E" give n.ddde+nn or n.dddE+nn (scientific format);
"g" and "G" put x[i] into scientific format only if it saves space to do so.
"fg" uses fixed format as "f", but digits as number of significant digits.
Note that this can lead to quite long result strings.}

\item{sidewaystable}{Logical value whether or not set the tabular environment=
"sidewaystable". Requires Latex "rotating" package in preamble.}

\item{longtable}{Logical value whether or not set the tabular environment=
"longtable". Requires Latex "longtable" package in preamble.}

\item{rotate}{Logical value whether or not set the tabular environment=
"rotate". No special arrangement is made to find space for the resut.
Requires Latex "rotating" package in preamble.
If TRUE, requires the rotate angle(counterclockwise).}

\item{turn}{Logical value whether or not set the tabular environment=
"turn". In this environment, Latex leaves space for the rotated table.
Requires Latex "rotating" package in preamble.
If TRUE, requires the rotate angle.}

\item{angle}{An integer indicate the angle to rotate(degree); range -180 to 180.}

\item{wraptable}{Logical value whether or not set the tabular environment=
"wraptable". Requires Latex "wrapfig" package in preamble.}

\item{wraptablewidth}{A integer indicate wraptable width in centimeter.}

\item{tabular}{Logical value whether or not set the tabular environment.
If TRUE, no tabular environment is set.}

\item{label}{Character vector of length 1 containing the LaTeX label or HTML anchor.
Set to NULL to suppress the label.}

\item{hline.after}{A vector of numbers between -1 and "nrow(x)", inclusive,
indicating the rows after which a horizontal line should appear.
If NULL is used no lines are produced. Default value is c(-1,0,nrow(x))
which means draw a line before and after the columns names and at the
end of the table. Repeated values are allowed.}

\item{booktabs}{Logical value. If TRUE, the toprule, midrule and bottomrule tags
from the LaTex "booktabs" package are used rather than hline for the
horizontal line tags. Requires Latex "booktabs" package in preamble.}

\item{prefix.rows}{A numeric vector contains the position of rows on which
extra Latex commands should be added as a prefix.}

\item{commands}{A character vector of the length 1 or same length of the nrow of
data.frame which contains the command that should be added as a prefix at
the specified rows.}

\item{top.command}{A character vector of the length 1 which contains the command
that should be added as a prefix at the colnames row.}

\item{zebra}{Null or a integer of 1 or 2. The arguments zebra and zebra.color are
used to make a Zebra striping table(table with alternating background colors)
easly. A value of 1 sets background color of all odd rows with specified with
zebra.color. A value of 2 sets all even rows. when zebra is 1 or 2,
the parameters of prefix.rows and commands ignored.}

\item{zebra.color}{A color name or a numeric value indicating pre-defined color.
When parameter zebra is 0 or 1 or 2 and zebra.color is NULL, then zerba.color
is set to "platinum". Numeric values between 1 to 13 is converted to
predefined color names. The predefined color names are c("peach","peach-orange",
"peachpuff","peach-yellow","pear","pearl","peridot","periwinkle","pastelred",
"pastelgray").}

\item{zebra.type}{An integer of 0 or 1 or 2 or 3. A value of 1 sets background colors by row.
A value of 2 sets background colors by column. A value of 0 sets background colors of all cells.
A value of 3 sets background colors of cells specified with zebra.list.
Default value is 1.}

\item{zebra.list}{A list consists of y,x,color. zebra.list is used only when zebra.type=3.
zebra.list sets the cells specified with cells[y,x] with "color". The y and x are
integer indicating rows and columns. NA value of y or x indicating all columns or rows.}

\item{zebra.colnames}{whether or not use background colors in column names row,
Default value is FALSE}

\item{zebra.rownames}{whether or not use background colors in row names column,
Default value is TRUE}

\item{colnames.bold}{whether or not use bold font for column names.}

\item{include.colnames}{Logical. If TRUE the column names is printed.}

\item{cgroup}{A character vector or matrix indicating names of column group. Default value is NULL}

\item{n.cgroup}{A integer vector or matrix indicating the numbers of columns included in each cgroup
Dafault value is NULL}

\item{rgroup}{A character vector indicating names of row group. Default value is NULL}

\item{n.rgroup}{A integer vector indicating the numbers of rows included in each rgroup
Dafault value is NULL}

\item{cspan.rgroup}{The number of columns that an rgroup should span. It spans by default all
columns but you may want to limit this if you have column colors that you want to retain.}
}
\description{
Update options of ztable before print
}

