% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mm_optim.R
\name{MM_optim}
\alias{MM_optim}
\title{Minorization-Maximisation Algorithm performed to fit the ADLPs}
\usage{
MM_optim(w_init, dat, niter = 500)
}
\arguments{
\item{w_init}{initial weights for each ADLP}

\item{dat}{matrix of densities for each ADLP}

\item{niter}{maximum number of iterations. Defaults to 500}
}
\value{
An object of class \code{mm_optim}. \code{mm_optim} is a list that stores the
results of the MM algorithm performed, including the final parameters, the
final loss and numer of iterations.
}
\description{
The Minorization-Maximization algorithm aims to optimize a
surrogate objective function that approximates the Log Score. This approach
typically results in fast and stable convergence, while ensuring that
combination weights adhere to the constraints of being non-negative and
summing to one. For detailed description of the algorithm, one might refer
to: Conflitti, De Mol, and Giannone (2015)
}
\examples{
w_init <- rep(1/3, 3)
set.seed(1)
density_data <- matrix(runif(9), nrow = 3, ncol = 3)
MM_optim(w_init, density_data, niter = 500)

}
\references{
Conflitti, Cristina, Christine De Mol, and Domenico Giannone. "Optimal combination of survey forecasts." International Journal of Forecasting 31.4 (2015): 1096-1103.
}
