% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHReg1.R
\name{hGLL}
\alias{hGLL}
\title{Generalized Log-logistic (GLL) hazard function.}
\usage{
hGLL(t, kappa, alpha, eta, log = FALSE)
}
\arguments{
\item{t}{: positive argument}

\item{kappa}{: scale parameter}

\item{alpha}{: shape parameter}

\item{eta}{: shape parameter}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
the value of the GLL hazard function
}
\description{
Generalized Log-logistic (GLL) hazard function.
}
\examples{
t=runif(10,min=0,max=1)
hGLL(t=t, kappa=0.5, alpha=0.35, eta=0.7, log=FALSE)

}
\references{
Muse, A. H., Mwalili, S., Ngesa, O., Alshanbari, H. M., Khosa, S. K., & Hussam, E. (2022). Bayesian and frequentist approach for the generalized log-logistic accelerated failure time model with applications to larynx-cancer patients. Alexandria Engineering Journal, 61(10), 7953-7978.
}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Mutua Kilai, \email{abdisalam.hassan@amoud.edu.so}
}
