#' Cocoa water requirement for land evaluation
    #' 
    #' A dataset containing the water characteristics of the crop requirements for farming Cocoa.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item WyAv - Annual precipitation (mm)
#' \item WmDryLen - Length dry season (months : P < 1/2 PET)
#' \item WmhDryXm - Mean rel. humidity dryest month (\%)
#' \item WmhDryXm - Mean rel. humidity dryest month (\%)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 4 rows and 8 columns
#' @name COCOAWater
NULL