#' Sesame water requirement for land evaluation
    #' 
    #' A dataset containing the water characteristics of the crop requirements for farming Sesame.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item WmAv1 - Mean precipitation of first month (mm)
#' \item WmAv2 - Mean precipitation of second month (mm)
#' \item WmAv3 - Mean precipitation of third month (mm)
#' \item WghAv - Relative humidity growing cycle (\%)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 4 rows and 8 columns
#' @name SESAMEWater
NULL