% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{apci.plot.heatmap}
\alias{apci.plot.heatmap}
\title{Plot the heatmap for APC-I model}
\usage{
apci.plot.heatmap(
  model,
  age,
  period,
  color_map = NULL,
  color_scale = NULL,
  quantile = NULL,
  ...
)
}
\arguments{
\item{model}{A list recording the results from function \code{apci}.}

\item{age}{An object of class character representing the age group index
taking on a small number of distinct values in the data. Usually, the vector
should be converted to a factor (or the terms of "category" and "enumerated
type").}

\item{period}{An object of class character, similar to the argument of age,
representing the time period index in the data.}

\item{color_map}{A vector, representing the color palettes to
be used in the figure. The default setting is greys if color_map is
\code{NULL}. Alternations, for example, can be c("blue", "yellow"),
blues, etc.}

\item{color_scale}{A vector including two numbers
indicating the limit of the values to be plotted. The
first number is the minimum value to be visualized and the
second is the maximum value to be visualized. If NULL, the
algorithm will automatically select the limits from the data
(estimation results) to set up the scale.}

\item{quantile}{A number valued between 0 and 1, representing the
desirable percentiles to be used in visualizing the data or model.
If \code{NULL}, the original scale of the outcome variable will be used.}

\item{\dots}{Additional arguments to be passed to the function.}
}
\value{
A heatmap visualizing cohort effects estimated by APC-I model.
}
\description{
Plot the heatmap to visualize cohort effects estimated by APC-I model.
}
\examples{
# load package
library("APCI")
# load data
test_data <- APCI::women9017
test_data$acc <- as.factor(test_data$acc)
test_data$pcc <- as.factor(test_data$pcc)
test_data$educc <- as.factor(test_data$educc)
test_data$educr <- as.factor(test_data$educr)

# fit APC-I model
APC_I <- APCI::apci(outcome = "inlfc",
                    age = "acc",
                    period = "pcc",
                    cohort = "ccc",
                    weight = "wt",
                    data = test_data,dev.test=FALSE,
                    print = TRUE,
                    family = "gaussian")
summary(APC_I)

# plot heatmap
apci.plot.heatmap(model=APC_I,age="acc",period="pcc",first_age = 20,
                  first_period = 1940, interval = 5)
}
