% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/True.R
\name{True_Estimation}
\alias{True_Estimation}
\title{True Estimation of Average Treatment Effect}
\usage{
True_Estimation(Y, A, Z, X)
}
\arguments{
\item{Y}{A numeric vector of outcomes.}

\item{A}{A numeric vector of treatment assignments.}

\item{Z}{A numeric vector of covariate Z.}

\item{X}{A numeric vector of covariate X.}
}
\value{
A numeric value representing the estimated treatment effect.
}
\description{
This function performs a true estimation of the Average Treatment Effect (ATE) using the generated values for X and Y.
The consistent estimator is calculated as the difference between the expected value of the outcome for the treated group
and the expected value of the outcome for the control group.
}
\details{
The expected value for the treated group, E(Y_1), is calculated as the mean of the product of the treatment assignment
and the outcome divided by the estimated propensity score.

The expected value for the control group, E(Y_0), is calculated as the mean of the product of the control assignment
and the outcome divided by one minus the estimated propensity score.

The propensity score is estimated by applying a logistic regression model to the true values of the covariates and
treatment assignments.
}
\examples{
library(ATE.ERROR)
data(Simulated_data)
Y <- Simulated_data$Y
A <- Simulated_data$T
Z <- Simulated_data$Z
X <- Simulated_data$X
True_ATE <- True_Estimation(Y, A, Z, X)
print(True_ATE)
}
