% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BonferroniNPTest.R
\name{BonferroniNPTest}
\alias{BonferroniNPTest}
\title{Bonferroni-Corrected Mann-Whitney Tests (Non-Parametric)}
\usage{
BonferroniNPTest(formula, data, alpha = 0.05)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}.}

\item{data}{A data frame containing the variables.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"bonferroni_np"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: Data frame with comparisons, W-statistics, raw and adjusted p-values, and significance levels.
  \item \code{Promedios}: Mean ranks of each group.
  \item \code{Orden_Medias}: Group names ordered from highest to lowest rank.
  \item \code{Metodo}: Name of the method used ("Bonferroni (non-parametric)").
}
}
\description{
Performs all pairwise comparisons using the Wilcoxon rank-sum test (Mann-Whitney)
with Bonferroni correction for multiple testing.
}
\details{
Suitable for non-parametric data where ANOVA assumptions are violated.

Advantages:
- Simple and intuitive non-parametric alternative to ANOVA post hoc tests.
- Strong control of Type I error via Bonferroni correction.
- Works with unequal group sizes.

Disadvantages:
- Conservative with many groups.
- Only valid for pairwise comparisons; does not support complex contrasts.
- It is only useful in completely random or single-factor designs.
}
\examples{
data(iris)
BonferroniNPTest(Sepal.Length ~ Species, data = iris)

}
\references{
Wilcoxon, F. (1945). Individual Comparisons by Ranking Methods. \emph{Biometrics Bulletin}, 1(6), 80–83. \doi{10.2307/3001968}

Dunn, O. J. (1964). Multiple Comparisons Using Rank Sums. \emph{Technometrics}, 6(3), 241–252. \doi{10.1080/00401706.1964.10490181}

Shaffer, J. P. (1995). Multiple Hypothesis Testing. \emph{Annual Review of Psychology}, 46(1), 561–584. \doi{10.1146/annurev.ps.46.020195.003021}
}
