#' An R package to extract sub-sequences from GenBank annotations under different synonyms
#'
#' @description An R package to extract sub-sequences from GenBank annotations under different synonyms.
#'
#' @details 
#' Package: AnnotationBustR
#' 
#' Type: Package
#' 
#' Title: An R package to extract sub-sequences from GenBank annotations under different synonyms
#' 
#' Version: 1.1
#' 
#' Date: 2017-8-15
#' 
#' License: GPL (>= 2)
#' 
#' This package allows users to quickly extract sub-sequences from GenBank accession numbers that may be annotated
#' under different synonyms. It writes these sub-sequences to FASTA files and creates a corresponding accession
#' table. The package comes with pre-made search terms with synonyms. A vignette going over the basic functions and
#' how to use them can be accessed with vignette("AnnotationBustR-vignette").
#' 
#' @author Samuel Borstein, Brian O'Meara.
#' Maintainer: Samuel Borstein <sborstei@vols.utk.edu>
#' 
#' @seealso \code{\link{AnnotationBust}},\code{\link{cpDNAterms}},\code{\link{FindLongestSeq}},\code{\link{MergeSearchTerms}},\code{\link{mtDNAterms}},\code{\link{rDNAterms}}
#' 
#' @docType package
#' @name AnnotationBustR
#"_PACKAGE"
#> [1] "_PACKAGE"
NULL