% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgroClimateData.R
\docType{data}
\name{AgroClimateData}
\alias{AgroClimateData}
\title{Daily Surface Meteorological Data (1982-2022) Extracted from AgERA5}
\format{
A data frame containing daily observations of weather variables:
\itemize{
\item \strong{GridID}: Grid ID of the location.
\item \strong{Lat}: Latitude of the grid in decimal degrees.
\item \strong{Lon}: Longitude of the grid in decimal degrees.
\item \strong{Elev}: Elevation above sea level in meters.
\item \strong{WHC}: Water holding capacity in millimeters (mm).
\item \strong{Year}: Year of record ("YYYY").
\item \strong{Month}: Month of record ("MM").
\item \strong{Day}: Day of record ("DD").
\item \strong{Rain}: Daily precipitation in millimeters (mm/day).
\item \strong{Tmax}: Daily maximum temperature at 2 meters height in degrees Celsius
(°C).
\item \strong{Tmin}: Daily minimum temperature at 2 meters height in degrees Celsius
(°C).
\item \strong{Rs}: Total amount of energy provided by solar radiation at the surface
over the period 00-24h local time per unit area and time (MJ/m^2/day).
\item \strong{Tdew}: Mean dew point temperature at a height of 2 meters above the
surface over the period 00h-24h local time (°C).
\item \strong{Uz}: Mean wind speed at a height of 2 meters above the surface over the
period 00h-24h local time (m/s).
}
}
\source{
\url{https://cds.climate.copernicus.eu/cdsapp#!/dataset/sis-agrometeorological-indicators?tab=overview}
}
\usage{
data(AgroClimateData)
}
\description{
The AgERA5 dataset provides daily surface meteorological data
for the period from 1979 to present as input for agriculture and
agro-ecological studies. This dataset is based on the hourly ECMWF ERA5 data
at surface level, with data from January 1, 1982, through December 31, 2022,
extracted for a grid located in Angochen, Nampula province of Mozambique.
}
\examples{
## Load the agroclimate data
data(AgroClimateData)

## Get the structure of the data frame
str(AgroClimateData)

## Get the head of the data frame
head(AgroClimateData)

}
\references{
AgERA5, 2021, Copernicus Climate Change Service (C3S), Fifth
generation of ECMWF atmospheric reanalysis of the global climate for
agriculture and agro-ecological studies. Copernicus Climate Change Service
Climate Data Store (CDS), July 2021.
}
\seealso{
\code{\link{climateData}}, \code{\link{calcEto}}
}
\keyword{datasets}
