% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_py_deps_venv}
\alias{install_py_deps_venv}
\title{Install Python dependencies for BERTopic (virtualenv route)}
\usage{
install_py_deps_venv(
  envname = "r-bertopic",
  python = NULL,
  reinstall = FALSE,
  validate = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{envname}{Character. Virtualenv name. Default \code{"r-bertopic"}.}

\item{python}{Character. Path to a Python executable to create the venv with.
If \code{NULL}, tries to find \code{python} / \code{python3} on PATH.}

\item{reinstall}{Logical. If \code{TRUE}, delete existing venv and recreate.}

\item{validate}{Logical. If \code{TRUE}, bind and validate imports (will skip
if reticulate is already initialized to another Python).}

\item{verbose}{Logical. Print progress messages.}
}
\value{
Invisibly returns the path to the Python executable inside the venv.
}
\description{
Creates (or reuses) a \code{virtualenv} and installs \code{bertopic==0.16.0}
plus required dependencies via pip. Optionally validates imports.
}
\examples{
\dontrun{
install_py_deps_venv(envname = "r-bertopic")
}
}
