% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSBInit.R
\name{BSBInit}
\alias{BSBInit}
\title{Initial setup for BSBHaz model}
\usage{
BSBInit(
  df = NULL,
  t1 = NULL,
  t2 = NULL,
  alpha = 0.001,
  beta = 0.001,
  c = 1000,
  part_len = 1,
  seed = 42
)
}
\arguments{
\item{df}{A data frame with columns 't1', 't2', 'delta1', 'delta2'. Any other
columns not named 'id' are taken to be predictors. These predictors must be
numeric, i.e., \strong{categorical predictors must be one-hot encoded}.}

\item{t1, t2}{Objects of class 'Surv' as created by
\code{\link[survival]{Surv}}.}

\item{alpha, beta, c}{Doubles. Parameters for Markov gamma hazard priors.}

\item{part_len}{A double that gives the length of time partition intervals.}

\item{seed}{Random seed for variable initialization.}
}
\value{
An object of class '\code{BSBinit}'
}
\description{
\code{BSBInit} creates the necessary data structure for use in
\code{\link{BSBHaz}}.
}
\details{
This function reads and formats censored bivariate survival data in the
following way. If \code{df} is provided, failure times and censoring
indicadors are assumed to be columns named 't1', 't2', 'delta1', and
'delta2'. Other columns not named 'id' (ignoring case) are taken to be
predictors. If \code{df} has no columns 'delta1' or 'delta2', observations
are taken as exact.

If \code{df} is not provided, then \code{t1} and \code{t2} are expected to be
objects of class 'Surv' created by \code{\link[survival]{Surv}} and the model
does not use predictors. Only right-censored observations are supported. Only
\code{df} or \code{t1} and \code{t2} must be supplied. \code{df} argument
comes first for use in pipes.
}
\examples{
t1 <- survival::Surv(c(1, 2, 3))
t2 <- survival::Surv(c(1, 2, 3))

init <- BSBInit(t1 = t1, t2 = t2, seed = 0)

}
