% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetData.R
\name{ReadInputsFromFile}
\alias{ReadInputsFromFile}
\title{Read a BLM Input File}
\usage{
ReadInputsFromFile(
  InputFile,
  ThisProblem = NULL,
  NInLab = ThisProblem$N["InLab"],
  InLabName = ThisProblem$InLabName,
  NInVar = ThisProblem$N["InVar"],
  InVarName = ThisProblem$InVar$Name,
  NInComp = ThisProblem$N["InComp"],
  InCompName = ThisProblem$InCompName
)
}
\arguments{
\item{InputFile}{character; the path and file name to a BLM input file}

\item{ThisProblem}{a list object following the template of BlankProblem}

\item{NInLab}{integer; number of input label columns}

\item{InLabName}{character vector of length `NInLab`; names of input columns}

\item{NInVar}{integer; Number of input variables}

\item{InVarName}{character vector of length `NInVar`; Names of input
variables}

\item{NInComp}{integer; Number in input components}

\item{InCompName}{character vector of length `NInComp`; names of input
components}
}
\value{
Returns a \code{list} object with the following components:
\describe{
 \item{\code{NObs}}{integer; the number of chemistry observations}
 \item{\code{InLabObs}}{matrix with \code{Obs} rows and \code{InLab}
   columns; the input labels for each observation}
 \item{\code{InVarObs}}{matrix with \code{Obs} rows and \code{InVar}
   columns; the input variables for each observation}
 \item{\code{InCompObs}}{matrix with \code{Obs} rows and \code{InComp}
   columns; the input component concentrations for each observation}
}
}
\description{
`ReadInputsFromFile` will read a BLM input file, assuming it
matches the problem as defined by the input arguments.
}
\examples{
myinputfile = system.file("extdata", "InputFiles",
                          "carbonate_system_test.blm4",
                          package = "BLMEngineInR", mustWork = TRUE)
ReadInputsFromFile(InputFile = myinputfile,
                   ThisProblem = carbonate_system_problem)

}
\seealso{
Other BLMEngine Functions: 
\code{\link{CommonParameterDefinitions}},
\code{\link{GetData}()},
\code{\link{MatchInputsToProblem}()}
}
\concept{BLMEngine Functions}
