% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Horseshoe.R
\name{horseshoe_mcmc}
\alias{horseshoe_mcmc}
\title{Horseshoe MCMC Sampler for Multiply-Imputed Regression}
\usage{
horseshoe_mcmc(
  X,
  Y,
  intercept = TRUE,
  nburn = 4000,
  npost = 4000,
  seed = NULL,
  verbose = TRUE,
  printevery = 1000,
  chain_index = 1
)
}
\arguments{
\item{X}{A 3-D array of predictors with dimensions \code{D × n × p}.}

\item{Y}{A matrix of outcomes with dimensions \code{D × n}.}

\item{intercept}{Logical; include an intercept term? Default \code{TRUE}.}

\item{nburn}{Integer; number of burn-in MCMC iterations. Default \code{4000}.}

\item{npost}{Integer; number of post-burn-in samples to retain. Default \code{4000}.}

\item{seed}{Integer or \code{NULL}; random seed for reproducibility. Default \code{NULL}.}

\item{verbose}{Logical; print progress messages? Default \code{TRUE}.}

\item{printevery}{Integer; print progress every this many iterations. Default \code{1000}.}

\item{chain_index}{Integer; index of this MCMC chain (for labeling prints). Default \code{1}.}
}
\value{
A named list with components:
\describe{
\item{\code{post_beta}}{Array \code{npost × D × p} of sampled regression coefficients.}
\item{\code{post_alpha}}{Matrix \code{npost × D} of sampled intercepts (if used).}
\item{\code{post_sigma2}}{Numeric vector of length \code{npost}, sampled residual variances.}
\item{\code{post_lambda2}}{Matrix \code{npost × p} of local shrinkage parameters \eqn{\lambda_j^2}.}
\item{\code{post_kappa}}{Matrix \code{npost × p} of auxiliary local hyperparameters \eqn{\kappa_j}.}
\item{\code{post_tau2}}{Numeric vector of length \code{npost}, sampled global scale \eqn{\tau^2}.}
\item{\code{post_eta}}{Numeric vector of length \code{npost}, sampled auxiliary global hyperparameter \eqn{\eta}.}
\item{\code{post_fitted_Y}}{Array \code{npost × D × n} of posterior predictive draws (with noise).}
\item{\code{post_pool_beta}}{Matrix \code{(npost * D) × p} of pooled coefficient draws.}
\item{\code{post_pool_fitted_Y}}{Matrix \code{(npost * D) × n} of pooled predictive draws (with noise).}
\item{\code{hat_matrix_proj}}{Matrix \code{D × n × n} of averaged projection hat-matrices. To avoid recalculate for estimating degree of freedom.}
}
}
\description{
Implements Bayesian variable selection using the hierarchical Horseshoe prior
across multiply-imputed datasets.  This model applies global–local shrinkage
to regression coefficients via a global scale (\code{tau2}), local scales
(\code{lambda2}), and auxiliary hyperpriors (\code{kappa}, \code{eta}).
}
\examples{
sim <- sim_B(n = 100, p = 20, type = "MAR", SNP = 1.5, corr = 0.5,
low_missing = TRUE, n_imp = 5, seed = 123)
X <- sim$data_MI$X
Y <- sim$data_MI$Y
fit <- horseshoe_mcmc(X, Y, nburn = 100, npost = 100)
}
