% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Engineer}
\alias{Engineer}
\title{Salaries after 10 years for graduates of three different universities}
\format{
A data frame/tibble with 51 observations on two variables
\describe{ 
\item{salary}{salary (in $1000) 10 years after graduation} 
\item{university}{a factor with levels \code{A}, \code{B}, and \code{C}} 
}
}
\usage{
Engineer
}
\description{
Data for Example 10.7
}
\examples{

boxplot(salary ~ university, data = Engineer,
        main = "Example 10.7", col = "yellow")
kruskal.test(salary ~ university, data = Engineer)
anova(lm(salary ~ university, data = Engineer))
anova(lm(rank(salary) ~ university, data = Engineer))

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
