% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s4-BSL.R
\docType{class}
\name{BSL-class}
\alias{BSL-class}
\alias{BSLclass}
\alias{show,BSL-method}
\alias{summary,BSL-method}
\alias{plot,BSL,ANY-method}
\alias{getTheta,BSL-method}
\alias{getLoglike,BSL-method}
\alias{getGamma,BSL-method}
\title{S4 class ``BSL''.}
\usage{
\S4method{show}{BSL}(object)

\S4method{summary}{BSL}(object, burnin = 0, thetaNames = NULL)

\S4method{plot}{BSL,ANY}(
  x,
  which = 1L,
  thin = 1,
  burnin = 0,
  thetaTrue = NULL,
  options.plot = NULL,
  top = "Approximate Univariate Posteriors",
  options.density = list(),
  options.theme = list()
)

\S4method{getTheta}{BSL}(object, burnin = 0, thin = 1)

\S4method{getLoglike}{BSL}(object, burnin = 0, thin = 1)

\S4method{getGamma}{BSL}(object, burnin = 0, thin = 1)
}
\arguments{
\item{object}{A ``BSL'' class object.}

\item{burnin}{the number of MCMC burn-in steps to be taken.}

\item{thetaNames}{Parameter names to be shown in the summary table. If not
given, parameter names of the ``BSL'' object will be used by default.}

\item{x}{A ``BSL'' class object to plot.}

\item{which}{An integer argument indicating which plot function to be
used. The default, \code{1L}, uses the plain \code{plot} to visualise the
result. \code{2L} uses ggplot2 to draw the plot.}

\item{thin}{A numeric argument indicating the gap between samples to
be taken when thinning the MCMC draws. The default is \code{1}, which means
no thinning is used.}

\item{thetaTrue}{A set of true parameter values to be included on the plots
as a reference line. The default is \code{NULL}.}

\item{options.plot}{A list of additional arguments to pass into the
\code{plot} function. Only use when \code{which} is \code{1L}.}

\item{top}{A character argument of the combined plot title if
\code{which} is \code{2L}.}

\item{options.density}{A list of additional arguments to pass into the
\code{geom_density} function. Only use when \code{which} is \code{2L}.}

\item{options.theme}{A list of additional arguments to pass into the
\code{theme} function. Only use when \code{which} is \code{2L}.}
}
\description{
The S4 class ``BSL'' is produced by running function
  \code{\link{bsl}} and contains the result of a BSL run. Basic S4 methods
  \code{show}, \code{summary} and \code{plot} are provided. \code{theta} and
  \code{loglike} returns the MCMC samples of parameter values and estimated
  log-likelihoods.
}
\section{Slots}{

\describe{
\item{\code{theta}}{Object of class ``matrix''. MCMC samples from the joint
approximate posterior distribution of the parameters.}

\item{\code{loglike}}{Object of class ``numeric''. Accepted MCMC samples of the
estimated log-likelihood values.}

\item{\code{call}}{Object of class ``call''. The original code that was used to call
the method.}

\item{\code{model}}{Object of class ``MODEL''.}

\item{\code{acceptanceRate}}{Object of class ``numeric''. The acceptance rate of the
MCMC algorithm.}

\item{\code{earlyRejectionRate}}{Object of class ``numeric''. The early rejection
rate of the algorithm (early rejection may occur when using bounded prior
distributions).}

\item{\code{errorRate}}{Object of class ``numeric''. The error rate. If any infinite
summary statistic or infinite log-likelihood estimate occurs during the
process, it is marked as an error and the proposed parameter will be
rejected.}

\item{\code{y}}{Object of class ``ANY''. The observed data.}

\item{\code{n}}{Object of class ``numeric''. The number of simulations from the model
per MCMC iteration to estimate the synthetic likelihood.}

\item{\code{M}}{Object of class ``numeric''. The number of MCMC iterations.}

\item{\code{covRandWalk}}{Object of class ``matrix''. The covariance matrix used in
multivariate normal random walk proposals.}

\item{\code{method}}{Object of class ``character''. The character argument indicating
the used method.}

\item{\code{shrinkage}}{Object of class ``characterOrNULL''. The character argument
indicating the shrinkage method.}

\item{\code{penalty}}{Object of class ``numericOrNULL''. The penalty value.}

\item{\code{GRC}}{Object of class ``logical''. Whether the Gaussian rank correlation
matrix is used.}

\item{\code{logitTransform}}{Object of class ``logical''. The logical argument
indicating whether a logit transformation is used in the algorithm.}

\item{\code{logitTransformBound}}{Object of class ``matrixOrNULL''. The matrix of
logitTransformBound.}

\item{\code{standardise}}{Object of class ``logical''. The logical argument that
determines whether to standardise the summary statistics.}

\item{\code{parallel}}{Object of class ``logical''. The logical value indicating
whether parallel computing is used in the process.}

\item{\code{parallelArgs}}{Object of class ``listOrNULL''. The list of additional
arguments to pass into the \code{foreach} function.}

\item{\code{time}}{Object of class ``difftime''. The running time.}

\item{\code{gamma}}{Object of class ``numeric''. MCMC samples of gamma parameter
values of the mean adjustment or variance inflation for method
``BSLmisspec''.}

\item{\code{misspecType}}{Object of class ``characterOrNULL''. The character argument
indicating whether mean adjustment ("mean") or variance inflation
("variance") to be used in "BSLmisspec" method.}

\item{\code{tau}}{Object of class ``numeric''. Parameter of the prior distribution
for "BSLmisspec" method. For mean adjustment, \code{tau} is the scale of
the Laplace distribution. For variance inflation, \code{tau} is the mean of
the exponential distribution.}

\item{\code{whitening}}{Object of class ``logicalOrMatrixOrNULL''. A logical argument
determines whether Whitening transformation is used in ``BSL'' method with
Warton's shrinkage, or just the Whitening matrix used.}
}}

\examples{
\dontshow{
# a toy example
toy_simVec <- function(n, theta) matrix(rnorm(n, theta), nrow = n) # the simulation function
toy_sum <- function(x) x # the summary statistic function
model <- newModel(fnSimVec = toy_simVec, fnSum = toy_sum, theta0 = 0) # create the model object
result_toy <- bsl(y = 1, n = 50, M = 100, model = model, covRandWalk = matrix(1), verbose = 0)
summary(result_toy)
plot(result_toy)
}
\dontrun{
# a toy example
toy_simVec <- function(n, theta) matrix(rnorm(n, theta), nrow = n) # the simulation function
toy_sum <- function(x) x # the summary statistic function
model <- newModel(fnSimVec = toy_simVec, fnSum = toy_sum, theta0 = 0) # create the model object
result_toy <- bsl(y = 1, n = 100, M = 1e4, model = model, covRandWalk = matrix(1))
summary(result_toy)
plot(result_toy)
}

}
\Rdversion{1.1}
