% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_YAMLConfigFile.R
\name{write_YAMLConfigFile}
\alias{write_YAMLConfigFile}
\title{Write Auto Generated YAML BayLum Configuration File to the Disc}
\usage{
write_YAMLConfigFile(output_file = NULL, ...)
}
\arguments{
\item{output_file}{\link{character} (\emph{with default}): valid file path of the output file}

\item{...}{parameters to be preset in the YAML file (run \code{write_YAMLConfigFile()} to see allowed parameters)
The parameter \code{sample} is special, because it can be provided as a \link{character} vector of any length. The number
of elements in the vector (sample names) are then used to multiply the records in the configuration file.}
}
\value{
The function has two output modes:
\itemize{
\item (1) \verb{output_file = <file_path>}: Writes a YAML into the specified path and returns this path.
\item (2) \code{output_file = NULL}: Returns a list of allowed function parameters that can be passed
to the function \strong{and} it returns a list that can be used a passed on to \link{create_DataFile}.
}
}
\description{
This little function helps to auto-generate a the BayLum YAML configuration file
or a \link{list} that can be passed to \link{create_DataFile}. The YAML file itself can be modified in any
text editor. The allowed parameters are extracted from the reference YAML file
}
\section{Function version}{
 0.1.0
}

\examples{

## generate list
write_YAMLConfigFile(
sample = c("samp1", "samp2"),
settings.rules.endTest = 10)

## generate file (here written in tempdir)
write_YAMLConfigFile(
 output_file = tempfile("configuration.yml"),
 sample = c("samp1", "samp2"),
 settings.rules.endTest = 10)

}
\seealso{
\link{create_DataFile}, \link[yaml:read_yaml]{yaml::read_yaml}, \link[Luminescence:read_BIN2R]{Luminescence::read_BIN2R}, \link[Luminescence:read_XSYG2R]{Luminescence::read_XSYG2R}
}
\author{
Sebastian Kreutzer, Institute of Geography, Ruprecht-Karl University of Heidelberg (Germany)
}
