% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnorm.R
\name{TruncNormal}
\alias{TruncNormal}
\alias{dtnorm}
\alias{tnorm}
\alias{ptnorm}
\alias{qtnorm}
\alias{rtnorm}
\title{The Truncated Normal Distribution}
\usage{
dtnorm(x, mu, sig, lwr, upr, log = FALSE)

ptnorm(q, mu, sig, lwr, upr, lower.tail = TRUE, log.p = FALSE)

qtnorm(p, mu, sig, lwr, upr, lower.tail = TRUE, log.p = FALSE)

rtnorm(n, mu, sig, lwr = -Inf, upr = Inf)
}
\arguments{
\item{x, q}{A vector of quantiles.}

\item{mu}{A real-valued mean.}

\item{sig}{A strictly positive standard deviation.}

\item{lwr}{A lower bound.}

\item{upr}{An upper bound.}

\item{log, log.p}{A logical value indication whether a probability \code{p} should be
given as \code{log(p)}}

\item{lower.tail}{A logical value indicating whether to take lower or upper
tail probabilities.}

\item{p}{A vector of probabilities.}

\item{n}{A number of observations.}
}
\value{
\code{dtnorm} gives the density, \code{ptnorm} gives the distribution function,
\code{qtnorm} gives the quantile function, and \code{rtnorm} generates random
variates.
The length of the result is determined by the length of \code{x} for \code{dtnorm}.
}
\description{
Density, distribution, quantile, and random variate generation functions for
the Truncated Normal distribution, with \code{mu} and \code{sig} equal to the mean and
standard deviation before truncation and truncated to \verb{[lwr, upr]}. Wrappers
for functions from \code{msm}.
}
\keyword{internal}
