% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.generate.grids}
\alias{GP.generate.grids}
\title{Create spatial grids.}
\usage{
GP.generate.grids(
  d = 1L,
  num_grids = 50L,
  grids_lim = c(-1, 1),
  random = FALSE
)
}
\arguments{
\item{d}{An integer number for the dimension of the space. The default value is 1.}

\item{num_grids}{An integer number for the number of grids in each dimension. The default value is 50.}

\item{grids_lim}{A vector of two real numbers for the range of the grids in each dimension. The default value is c(-1,1).}

\item{random}{A logical value indicating whether each dimension of the grids is generated from a uniform distribution or fixed as equally-spaced.}
}
\value{
A matrix with d columns and num_grids^d rows.
}
\description{
Create spatial grids.
}
\examples{
x = GP.generate.grids(d=2L)
require(lattice)
y = sin(abs(x[,1]+x[,2]))
levelplot(y~x[,1]+x[,2])
}
\author{
Jian Kang <jiankang@umich.edu>
}
