/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.io.NewickImporter;
import dr.evolution.tree.SplitSystem;
import dr.evolution.tree.SplitUtils;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import java.io.FileReader;
import java.util.List;

@Deprecated
public class TreeMetrics {
    private static int MAX_OFFSET = 1000;

    public static double getRobinsonFouldsDistance(Tree tree, Tree tree2) {
        SplitSystem splitSystem = SplitUtils.getSplits(tree);
        return TreeMetrics.getRobinsonFouldsDistance(splitSystem, tree2);
    }

    public static double getRobinsonFouldsDistance(SplitSystem splitSystem, Tree tree) {
        int n;
        TaxonList taxonList = splitSystem.getTaxonList();
        SplitSystem splitSystem2 = SplitUtils.getSplits(taxonList, tree);
        if (splitSystem.getLabelCount() != splitSystem2.getLabelCount()) {
            throw new IllegalArgumentException("Number of labels must be the same!");
        }
        int n2 = splitSystem.getSplitCount();
        int n3 = splitSystem2.getSplitCount();
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            if (splitSystem2.hasSplit(splitSystem.getSplit(n))) continue;
            ++n4;
        }
        n = 0;
        for (int i = 0; i < n3; ++i) {
            if (splitSystem.hasSplit(splitSystem2.getSplit(i))) continue;
            ++n;
        }
        return 0.5 * ((double)n + (double)n4);
    }

    public static double getRobinsonFouldsRescaledDistance(Tree tree, Tree tree2) {
        SplitSystem splitSystem = SplitUtils.getSplits(tree);
        return TreeMetrics.getRobinsonFouldsRescaledDistance(splitSystem, tree2);
    }

    public static double getRobinsonFouldsRescaledDistance(SplitSystem splitSystem, Tree tree) {
        return TreeMetrics.getRobinsonFouldsDistance(splitSystem, tree) / (double)splitSystem.getSplitCount();
    }

    private static void analyze(List<Tree> list, int n) {
        int n2;
        TaxonList taxonList = list.get(0);
        System.out.println("Calculating splits...");
        SplitSystem[] splitSystemArray = new SplitSystem[list.size()];
        for (n2 = 0; n2 < splitSystemArray.length; ++n2) {
            splitSystemArray[n2] = SplitUtils.getSplits(taxonList, list.get(n2));
        }
        n2 = MAX_OFFSET;
        int n3 = list.size();
        if (n3 / 3 < n2) {
            n2 = n3 / 3;
        }
        double[] dArray = new double[n2];
        System.out.println("Calculating mean distance per lag...");
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < n3 - i; ++j) {
                double d = TreeMetrics.getRobinsonFouldsRescaledDistance(splitSystemArray[i], list.get(j));
                int n4 = i;
                dArray[n4] = dArray[n4] + d;
            }
            int n5 = i;
            dArray[n5] = dArray[n5] / ((double)n3 - (double)i);
            System.out.println(dArray[i]);
        }
    }

    public static final void main(String[] stringArray) throws Exception {
        FileReader fileReader = new FileReader(stringArray[0]);
        NewickImporter newickImporter = new NewickImporter(fileReader);
        List<Tree> list = newickImporter.importTrees(null);
        System.out.println("Imported " + list.size() + " trees...");
        TreeMetrics.analyze(list, 1000);
    }
}

