% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit.hessian.R
\name{logit.hessian}
\alias{logit.hessian}
\title{Hessian (curvature matrix)}
\usage{
logit.hessian(
  x = x,
  f = f,
  del = rep(0.002, length(x$est)),
  dapprox = FALSE,
  nfcn = 0
)
}
\arguments{
\item{x}{a list with components 'label' (of mode character), 'est' (the
parameter vector with the initial guess), 'low' (vector with lower bounds),
and 'upp' (vector with upper bounds)}

\item{f}{the function for which the Hessian is to be computed at point x}

\item{del}{step size on logit scale (numeric)}

\item{dapprox}{logical variable. If TRUE the off-diagonal elements are set
to zero. If FALSE (default) the full Hessian is computed}

\item{nfcn}{number of function calls}
}
\value{
returns list with \item{df }{ first derivatives (logit scale) }
\item{ddf }{ Hessian (logit scale) } \item{nfcn }{ number of function calls
} \item{eigen }{ eigen values (logit scale) }
}
\description{
Numerical evaluation of the Hessian of a real function f: \eqn{R^n }{R^n ->
R}\eqn{ \rightarrow R}{R^n -> R} on a generalized logit scale, i.e. using
transformed parameters according to x'=log((x-xl)/(xu-x))), with xl < x <
xu.
}
\details{
This version uses a symmetric grid for the numerical evaluation computation
of first and second derivatives.
}
\note{
This function is part of the Bhat exploration tool
}
\examples{

  ## Rosenbrock Banana function
   fr <- function(x) {
         x1 <- x[1]
         x2 <- x[2]
         100 * (x2 - x1 * x1)^2 + (1 - x1)^2
    }
  ## define
   x <- list(label=c("a","b"),est=c(1,1),low=c(-100,-100),upp=c(100,100))
   logit.hessian(x,f=fr,del=dqstep(x,f=fr,sens=0.01))
  ## shows the differences in curvature at the minimum of the Banana
  ## function along principal axis (in a logit-transformed coordinate system)

}
\seealso{
\code{\link{dfp}}, \code{\link{newton}}, \code{\link{ftrf}},
\code{\link{btrf}}, \code{\link{dqstep}}
}
\author{
E. Georg Luebeck (FHCRC)
}
\keyword{array}
\keyword{iteration}
\keyword{methods}
\keyword{optimize}
