% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bilex.R
\name{bilex}
\alias{bilex}
\title{Bilex Function}
\usage{
bilex(R_file, T_file, has_header = FALSE)
}
\arguments{
\item{R_file}{The filename of the CSV file containing the matrix R (located in inst/extdata).}

\item{T_file}{The filename of the CSV file containing the matrix T (located in inst/extdata).}

\item{has_header}{Logical, indicating if the CSV files have a header row. Default is FALSE.}
}
\value{
A modified matrix R according to the specified rules.
}
\description{
This function reads two CSV files containing matrices of values (T_file and R_file) and applies a transformation to matrix R according to certain rules.
}
\details{
This function performs a transformation on matrix R based on the following rules:
- If a value in R is 0, it is replaced by a classification value.
- Classification values are determined based on comparisons between neighboring values in R and corresponding values in T.
- The classification of each value in R depends on the values in the same row of R, considering both numerical values and the relationship with neighboring values.
}
\examples{
\donttest{
bilex_result <- bilex(system.file("extdata", "R.csv", package = "BiObjClass"),
system.file("extdata", "T.csv", package = "BiObjClass"), has_header = TRUE)
}

\donttest{
bilex_result <- bilex(system.file("extdata", "R.csv", package = "BiObjClass"),
system.file("extdata", "T.csv", package = "BiObjClass"))
}

}
