% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdNormalize_hdf5}
\alias{bdNormalize_hdf5}
\title{Normalize dataset in HDF5 file}
\usage{
bdNormalize_hdf5(
  filename,
  group,
  dataset,
  bcenter = NULL,
  bscale = NULL,
  byrows = NULL,
  wsize = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{filename}{String indicating the HDF5 file path}

\item{group}{String specifying the group containing the dataset}

\item{dataset}{String specifying the dataset name to normalize}

\item{bcenter}{Optional boolean indicating whether to center the data.
If TRUE (default), subtracts mean from each column/row}

\item{bscale}{Optional boolean indicating whether to scale the data.
If TRUE (default), divides by standard deviation}

\item{byrows}{Optional boolean indicating whether to operate by rows.
If TRUE, processes row-wise; if FALSE (default), column-wise}

\item{wsize}{Optional integer specifying the block size for processing.
Default is 1000}

\item{overwrite}{Optional boolean indicating whether to overwrite existing datasets.
Default is false}
}
\value{
List with components. If an error occurs, all string values are
returned as empty strings (""):
\describe{
\item{fn}{Character string. Path to the HDF5 file containing the results}
\item{ds}{Character string. Full dataset path to the normalized data, stored under "NORMALIZED/\[group\]/\[dataset\]"}
\item{mean}{Character string. Dataset path to the column means used for centering, stored under "NORMALIZED/\[group\]/mean.\[dataset\]"}
\item{sd}{Character string. Dataset path to the standard deviations used for scaling, stored under "NORMALIZED/\[group\]/sd.\[dataset\]"}
}
}
\description{
Performs block-wise normalization of datasets stored in HDF5 format through
centering and/or scaling operations. Supports both row-wise and column-wise
normalization with memory-efficient block processing.
}
\details{
The function implements block-wise normalization through:

Statistical computations:
\itemize{
\item Mean calculation (for centering)
\item Standard deviation calculation (for scaling)
\item Efficient block-wise updates
}

Memory efficiency:
\itemize{
\item Block-wise data processing
\item Minimal temporary storage
\item Proper resource cleanup
}

Processing options:
\itemize{
\item Row-wise or column-wise operations
\item Flexible block size selection
\item Optional centering and scaling
}

Error handling:
\itemize{
\item Input validation
\item Resource management
\item Exception handling
}
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create test data
data <- matrix(rnorm(1000*100), 1000, 100)

# Save to HDF5
bdCreate_hdf5_matrix("test.hdf5", data, "data", "matrix",
                     overwriteFile = TRUE)

# Normalize data
bdNormalize_hdf5("test.hdf5", "data", "matrix",
                 bcenter = TRUE,
                 bscale = TRUE,
                 wsize = 1000)
}

}
