% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdSolve}
\alias{bdSolve}
\title{Solve Linear System AX = B (In-Memory)}
\usage{
bdSolve(A, B)
}
\arguments{
\item{A}{Numeric matrix. The coefficient matrix (must be square).}

\item{B}{Numeric matrix. The right-hand side matrix (must have same number of
rows as A).}
}
\value{
Numeric matrix X, the solution to AX = B.
}
\description{
Solves the linear system AX = B where A is an N-by-N matrix and X and B are
N-by-NRHS matrices. The function automatically detects if A is symmetric and
uses the appropriate solver.
}
\details{
This function provides an efficient implementation for solving linear systems
using LAPACK routines. Key features:
\itemize{
\item Automatic detection of matrix properties:
\itemize{
\item Checks for matrix symmetry
\item Selects optimal solver based on matrix structure
}
\item Solver selection:
\itemize{
\item Symmetric systems: Uses LAPACK's dsysv routine
\item Non-symmetric systems: Uses LAPACK's dgesv routine
}
\item Performance optimizations:
\itemize{
\item Automatic workspace sizing
\item Efficient memory management
\item Support for multiple right-hand sides
}
}

The implementation ensures:
\itemize{
\item Robust error handling
\item Efficient memory usage
\item Numerical stability
\item Support for various matrix sizes
}
}
\examples{
library(BigDataStatMeth)

# Create test matrices
n <- 500
m <- 500

A <- matrix(runif(n*m), nrow = n, ncol = m)
B <- matrix(runif(n), nrow = n)
AS <- A \%*\% t(A)  # Create symmetric matrix

# Solve using bdSolve
X <- bdSolve(A, B)

# Compare with R's solve
XR <- solve(A, B)
all.equal(X, XR, check.attributes=FALSE)

}
\references{
\itemize{
\item Anderson, E. et al. (1999). LAPACK Users' Guide, 3rd Edition.
SIAM, Philadelphia.
\item Golub, G. H., & Van Loan, C. F. (2013). Matrix Computations, 4th Edition.
Johns Hopkins University Press.
}
}
\seealso{
\itemize{
\item \code{\link{bdSolve_hdf5}} for solving systems with HDF5-stored matrices
\item \code{\link{solve}} for R's built-in solver
}
}
