% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgwt_main.R
\name{runSGWT}
\alias{runSGWT}
\title{Run SGWT forward and inverse transforms for all signals}
\usage{
runSGWT(SG, use_batch = TRUE, verbose = TRUE)
}
\arguments{
\item{SG}{SGWT object with Graph slot populated}

\item{use_batch}{Whether to use batch processing for multiple signals (default: TRUE)}

\item{verbose}{Whether to print progress messages (default: TRUE)}
}
\value{
Updated SGWT object with Forward and Inverse slots populated
}
\description{
Perform SGWT analysis on all signals in the SGWT object.
Uses batch processing for multiple signals when possible for efficiency.
Assumes Graph slot is populated by runSpecGraph().
}
\examples{
\donttest{
# Create example data
data <- data.frame(x = runif(100), y = runif(100), signal = rnorm(100))
SG <- initSGWT(data, signals = "signal")
SG <- runSpecGraph(SG, k = 15)

# Uses batch processing by default
SG <- runSGWT(SG)

# Or force individual processing
SG2 <- initSGWT(data, signals = "signal")
SG2 <- runSpecGraph(SG2, k = 15)
SG2 <- runSGWT(SG2, use_batch = FALSE)
}
}
