% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bivrecSurv.R
\name{plot.bivrecSurv}
\alias{plot.bivrecSurv}
\title{Plot Bivariate Alternating Recurrent Series}
\usage{
\method{plot}{bivrecSurv}(
  x,
  y = NULL,
  by,
  type = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  col = NULL,
  ...
)
}
\arguments{
\item{x}{A \verb{bivrecSurv} object.}

\item{y}{Either empty or NULL.}

\item{by}{A vector or data frame with categorical variables. See details.}

\item{type}{Optional vector of strings to label Type I and Type II gap times. Default is c("Type I", "Type II").}

\item{main}{Optional string with plot title. Default is no title (will go to default when using \verb{by} argument).}

\item{xlab}{Optional string with label for horizontal axis. Default is "Time".}

\item{ylab}{Optional string with label for vertical axis. Default is "Individual".}

\item{col}{Optional string vector with colors to use for each of the gap types. Default is c("red", "blue")}

\item{...}{Additional arguments to be passed to graphical methods if needed.}
}
\description{
This function plots bivariate recurrent event gap times from a \verb{bivrecSurv} object with an option to create separate plots based on categorical covariates.
}
\details{
Argument \verb{by} must be a vector or data frame with one or several categorical variables (up to 6 categories each).
Plots of the bivariate alternating recurrent outcome will be created by category for each variable.
When the \verb{by} argument is used it overrides the \verb{main} argument and sets it to its default \verb{main=""}.
To avoid errors make sure the vectors used for the \verb{bivrecSurv} object have the same length as the categorical variables and no missing values.
}
\examples{
\dontrun{
# Simulate bivariate alternating recurrent event data
library(BivRec)
set.seed(28)
bivrec_data <- simBivRec(nsize=100, beta1=c(0.5,0.5), beta2=c(0,-0.5), tau_c=63,
               set=1.1)
plot(x = with(bivrec_data,bivrecSurv(id, epi, xij, yij, d1, d2)), main="Example",
     type = c("In Hospital", "Out of Hospital"))

#Present the data by subgroups
#Note that the covariate a2 in the function will be dropped because it is continuous
attach(bivrec_data)
plot(x = bivrecSurv(id, epi, xij, yij, d1, d2), by = data.frame(a1, a2),
     type = c("In Hospital", "Out of Hospital"))
detach(bivrec_data)
}
}
