% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuddleMain.R
\name{MakeConfusionMatrix}
\alias{MakeConfusionMatrix}
\title{Making a Confusion Matrix.}
\usage{
MakeConfusionMatrix(predicted.label, true.label, Label)
}
\arguments{
\item{predicted.label}{a vector of predicted labels.}

\item{true.label}{a vector of true labels.}

\item{Label}{a vector of all possible values or levels which a label can take.}
}
\value{
An r-by-r confusion matrix where r is the length of Label.
}
\description{
Create a confusion matrix from two vectors of labels: predicted label obtained from FetchBuddle() as a result of prediction and true label of a test set.
}
\examples{


data(iris)

Label = c("setosa", "versicolor", "virginica")

predicted.label = c("setosa", "setosa",    "virginica", "setosa", "versicolor", "versicolor")
true.label      = c("setosa", "virginica", "versicolor","setosa", "versicolor", "virginica")

confusion.matrix = MakeConfusionMatrix(predicted.label, true.label, Label)
precision = GetPrecision(confusion.matrix)

confusion.matrix
precision





}
\seealso{
CheckNonNumeric(), GetPrecision(), FetchBuddle(), OneHot2Label(), Split2TrainTest(), TrainBuddle()
}
