% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brier.R
\name{brier}
\alias{brier}
\title{Estimation of the Brier Score (EXPERIMENTAL)}
\usage{
brier(
  labels,
  predictions,
  iid = NULL,
  fold = NULL,
  observation = NULL,
  null = NA,
  conf.level = 0.95,
  transformation = TRUE
)
}
\arguments{
\item{labels}{[integer/character vector] the disease status (should only take two different values).}

\item{predictions}{[numeric vector] A vector with the same length as \code{labels} containing the biomarker values.}

\item{iid}{[array, optional] influence function of the prediction. For cross validation (CV) should be a 3 dimensional array (one slice per CV fold).
Otherwise a matrix with as many column as observations and rows as predictions.}

\item{fold}{[character/integer vector] If using cross validation, the index of the fold. 
Should have the same length as \code{labels}.}

\item{observation}{[integer vector] If using cross validation, the index of the corresponding observation in the original dataset.
Necessary to compute the standard error when using cross validation.}

\item{null}{[numeric, 0-1] the value against which the AUC should be compared when computing the p-value.}

\item{conf.level}{[numeric, 0-1] the confidence level of the confidence intervals.}

\item{transformation}{[logical] should a log-log transformation be used when computing the confidence intervals and the p-value.}
}
\value{
An S3 object of class \code{BuyseTestBrier} that inherits from data.frame.
}
\description{
Estimation of the brier score, possibly after cross validation,
to assess the discriminant ability and calibration of a biomarker regarding a disease status.
}
\keyword{models}
