
#' Example dataset: HardCase
#'
#' A dataset containing simulated conditional independence test results.
#'
#' @format A data frame with 500 rows and 3 variables:
#' \describe{
#'   \item{X}{Numeric vector}
#'   \item{Y}{Numeric vector}
#'   \item{Z1}{Conditioning variable}
#'   \item{Z2}{Conditioning variable}
#' }
#' @source Simulated data.
"HardCase"

#' Example dataset: ExponentialNoise
#'
#' A dataset containing simulated conditional independence test results.
#'
#' @format A data frame with 600 rows and 3 variables:
#' \describe{
#'   \item{X}{Numeric vector}
#'   \item{Y}{Numeric vector}
#'   \item{Z1}{Conditioning variable}
#'   \item{Z2}{Conditioning variable}
#' }
#' @source Simulated data.
"ExponentialNoise"


#' Example dataset: NormalData
#' 
#' A dataset containing simulated data from a multivariate normal distribution.
#' 
#' @format A data frame with 400 rows and 4 variables:
#' \describe{
#'  \item{X}{Numeric vector}
#'  \item{Y}{Numeric vector}
#'  \item{Z1}{Conditioning variable}
#'  \item{Z2}{Conditioning variable}
#'  }
#'  @source Simulated data.
"NormalData"

#' Example dataset: PolyData
#' 
#' A dataset containing simulated data from a polynomial relationship.
#' 
#' @format A data frame with 600 rows and 4 variables:
#' \describe{
#' \item{X}{Numeric vector}
#' \item{Y}{Numeric vector}
#' \item{Z1}{Conditioning variable}
#' \item{Z2}{Conditioning variable}
#' }
#' @source Simulated data.
"PolyData"

#' Example dataset: PoissonNoise
#' 
#' A dataset containing simulated data from a Poisson distribution.
#' 
#' @format A data frame with 1000 rows and 4 variables:
#' \describe{
#' \item{X}{Numeric vector}
#' \item{Y}{Numeric vector}
#' \item{Z1}{Conditioning variable}
#' \item{Z2}{Conditioning variable}
#' }
#' @source Simulated data.
"PoissonNoise"

#' Example dataset: NonLinNormal
#' 
#' A dataset containing simulated data from a non-linear transformation of a multivariate normal distribution.
#' 
#' @format A data frame with 500 rows and 4 variables:
#' \describe{
#' \item{X}{Numeric vector}
#' \item{Y}{Numeric vector}
#' \item{Z1}{Conditioning variable}
#' \item{Z2}{Conditioning variable}
#' }
#' @source Simulated data.
"NonLinNormal"

#' Example dataset: NonLinearCategorization
#' 
#' A dataset containing simulated data from a non-linear transformation followed by categorization.
#' 
#' @format A data frame with 600 rows and 3 variables:
#' \describe{
#' \item{X}{Numeric vector}
#' \item{Y}{Numeric vector}
#' \item{Z}{Conditioning variable}
#' }
#' @source Simulated data.
"NonLinearCategorization"

#' Example dataset: UniformNoise_large
#' 
#' A dataset containing simulated data with uniform noise.
#' 
#' @format A data frame with 20000 rows and 4 variables:
#' \describe{
#' \item{X}{Numeric vector}
#' \item{Y}{Numeric vector}
#' \item{Z1}{Conditioning variable}
#' \item{Z2}{Conditioning variable}
#' }
#' @source Simulated data.
"UniformNoise_large"

#' Example dataset: NonLinNormalZs_d0
#' 
#' A dataset containing simulated data with uniform noise.
#' 
#' @format A data frame with 1000 rows and 15 variables:
#' \describe{
#' \item{X}{Numeric vector}
#' \item{Y}{Numeric vector}
#' \item{Z1}{Conditioning variable}
#' \item{Z2}{Conditioning variable}
#' \item{Z3}{Conditioning variable}
#' \item{Z4}{Conditioning variable}
#' \item{Z5}{Conditioning variable}
#' \item{Z6}{Conditioning variable}
#' \item{Z7}{Conditioning variable}
#' \item{Z8}{Conditioning variable}
#' \item{Z9}{Conditioning variable}
#' \item{Z10}{Conditioning variable}
#' \item{Z11}{Conditioning variable}
#' \item{Z12}{Conditioning variable}
#' \item{Z13}{Conditioning variable}
#' \item{Z14}{Conditioning variable}
#' \item{Z15}{Conditioning variable}
#' }
#' @source Simulated data.
"NonLinNormalZs_d0"


#' Example dataset: NonLinNormalZs_d05
#' 
#' A dataset containing simulated data with uniform noise.
#' 
#' @format A data frame with 1000 rows and 15 variables:
#' \describe{
#' \item{X}{Numeric vector}
#' \item{Y}{Numeric vector}
#' \item{Z1}{Conditioning variable}
#' \item{Z2}{Conditioning variable}
#' \item{Z3}{Conditioning variable}
#' \item{Z4}{Conditioning variable}
#' \item{Z5}{Conditioning variable}
#' \item{Z6}{Conditioning variable}
#' \item{Z7}{Conditioning variable}
#' \item{Z8}{Conditioning variable}
#' \item{Z9}{Conditioning variable}
#' \item{Z10}{Conditioning variable}
#' \item{Z11}{Conditioning variable}
#' \item{Z12}{Conditioning variable}
#' \item{Z13}{Conditioning variable}
#' \item{Z14}{Conditioning variable}
#' \item{Z15}{Conditioning variable}
#' }
#' @source Simulated data.
"NonLinNormalZs_d05"











