% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeEvalScript.R
\name{MakeEvalScript}
\alias{MakeEvalScript}
\title{Create a Sentinel Hub API Evalscript}
\usage{
MakeEvalScript(x, ...)
}
\arguments{
\item{x}{A \code{character} string with the \code{short_name} of a spectral index
from \code{rsi::spectral_indices()} or a single-row \code{data.frame} (or \code{list})
with the elements \code{bands}, \code{formula}, \code{platforms},
and optionally \code{long_name}.}

\item{...}{Named arguments providing values for any constants required by the
index's formula. The function will stop if a required constant is missing
and warn if unused arguments are provided.}
}
\value{
A `character` vector containing the JavaScript evalscript. It can be used as
`script` argument in functions that require one as shown here:

\code{..., script = paste(MakeEvalScript("NDVI"), collapse = "\n"), ...}.

It can also be saved to a file for later use or further modifications.
}
\description{
Generates a JavaScript evalscript for calculating a spectral index for
Sentinel-1 or Sentinel-2 imagery.
}
\details{
This function takes a spectral index definition and creates a JavaScript
evalscript compatible with the Sentinel Hub API. The index can be specified
by its short name from the \code{rsi} package's spectral index database
(see \code{rsi::spectral_indices()}) or as a custom \code{list} or \code{data.frame}.

The function automatically maps common band names (e.g., `N`, `R`, `G`, `B`)
to the corresponding Sentinel-1 or Sentinel-2 band names required by the
API. Any constants in the index formula (e.g., the soil adjustment factor
`L` in SAVI) must be provided as named arguments.
}
\examples{
\dontrun{

# NDVI
si <- rsi::spectral_indices() # retrieves spectral indices
ndvi <- subset(si, short_name == "NDVI") # creates one-row data.frame
ndvi_script <- MakeEvalScript(ndvi) # generates the script
cat(ndvi_script, sep = "\n")

# SAVI, which requires the constant L
cat(MakeEvalScript("SAVI", L = 0.5), sep = "\n", file = "SAVI.js")

# Using a custom index definition as a data.frame
custom_index <- data.frame(
  short_name = "GNDVI",
  long_name = "Green Normalized Difference Vegetation Index",
  platforms = I(list("Sentinel-2")),
  bands = I(list(c("N", "G"))),
  formula = "(N - G) / (N + G)"
)
cat(MakeEvalScript(custom_index))
}
}
