% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liftone_GLM.R
\name{liftone_GLM}
\alias{liftone_GLM}
\title{Unconstrained lift-one algorithm to find D-optimal allocations for GLM}
\usage{
liftone_GLM(
  X,
  W,
  reltol = 1e-05,
  maxit = 500,
  random = TRUE,
  nram = 3,
  w00 = NULL,
  label = NULL
)
}
\arguments{
\item{X}{Model matrix, with nrow = num of design points and ncol = num of parameters}

\item{W}{Diagonal of W matrix in Fisher information matrix, can be calculated from W_func_GLM in package}

\item{reltol}{The relative convergence tolerance, default value 1e-5}

\item{maxit}{The maximum number of iterations, default value 500}

\item{random}{TRUE or FALSE, if TRUE then the function will run with additional "nram" number of random initial points, default to be TRUE}

\item{nram}{When random == TRUE, the function will generate nram number of initial points, default is 3}

\item{w00}{Specified initial design proportion; default to be NULL, this will generate a random initial design}

\item{label}{A vector of text strings for subgroups' names, default value NULL}
}
\value{
w is the approximate D-optimal design

w0 is the initial design used to get optimal design w

Maximum is the maximized |F| value

itmax is the number of iterations

convergence is TRUE or FALSE, if TRUE means the reported design is converged
}
\description{
Unconstrained lift-one algorithm to find D-optimal allocations for GLM
}
\examples{
beta = c(0.5, 0.5, 0.5)
X = matrix(data=c(1,-1,-1,1,-1,1,1,1,-1), byrow=TRUE, nrow=3)
W_matrix = W_func_GLM(X=X, beta=beta)
w00 = c(1/6, 1/6, 2/3)
approximate_design = liftone_GLM(X=X, W=W_matrix, reltol=1e-10, maxit=100,
random=FALSE, nram=3, w00=w00)

}
