% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergeRefToExp.R
\name{CST_MergeRefToExp}
\alias{CST_MergeRefToExp}
\title{Merge a Reference To Experiments}
\usage{
CST_MergeRefToExp(
  data1,
  data2,
  start1 = NULL,
  end1 = NULL,
  start2 = NULL,
  end2 = NULL,
  time_dim = "time",
  memb_dim = "member",
  ncores = NULL
)
}
\arguments{
\item{data1}{An 's2dv_cube' object with the element 'data' being a
multidimensional array with named dimensions. All dimensions must be 
equal to 'data2' dimensions except for the ones specified with 'memb_dim' 
and 'time_dim'. If 'start1' and 'end1' are used to subset a period, the
Dates must be stored in element '$attrs$Dates' of the object. Dates must 
have same time dimensions as element 'data'.}

\item{data2}{An 's2dv_cube' object with the element 'data' being a 
multidimensional array of named dimensions matching the dimensions of 
parameter 'data1'. All dimensions must be equal to 'data1' except for the 
ones specified with 'memb_dim' and 'time_dim'. If 'start2' and 'end2' are 
used to subset a period, the Dates must be stored in element '$attrs$Dates' 
of the object. Dates must have same time dimensions as element 'data'.}

\item{start1}{A list to define the initial date of the period to select from 
'data1' by providing a list of two elements: the initial date of the period 
and the initial month of the period.}

\item{end1}{A list to define the final date of the period to select from 
'data1' by providing a list of two elements: the final day of the period and 
the final month of the period.}

\item{start2}{A list to define the initial date of the period to select from 
'data2' by providing a list of two elements: the initial date of the period 
and the initial month of the period.}

\item{end2}{A list to define the final date of the period to select from 
'data2' by providing a list of two elements: the final day of the period and 
the final month of the period.}

\item{time_dim}{A character string indicating the name of the temporal 
dimension that will be used to combine the two arrays. By default, it is set 
to 'time'. Also, it will be used to subset the data in a requested 
period.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. If the data are not ensemble ones, set as NULL. The default 
value is 'member'.}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
An 's2dv_cube' object containing the indicator in the element 
\code{data}. The element \code{data} will be a multidimensional array created 
from the combination of 'data1' and 'data2'. The resulting array will contain 
the following dimensions: the original dimensions of the input data, which are 
common to both arrays and for the 'time_dim' dimension, the sum of the 
corresponding dimension of 'data1' and 'data2'. If 'memb_dim' is not null, 
regarding member dimension, two different situations can occur: (1) in the 
case that one of the arrays does not have member dimension or is equal to 1 
and the other array has multiple member dimension, the result will contain the 
repeated values of the array one up to the lenght of member dimension of array 
two; (2) in the case that both arrays have member dimension and is greater 
than 1, all combinations of member dimension will be returned. The other 
elements of the 's2dv_cube' will be updated with the combined information of 
both datasets.
}
\description{
Some indicators are defined for specific temporal periods (e.g.: summer from 
June 21st to September 21st). If the initialization forecast date is later 
than the one required for the indicator (e.g.: July 1st), the user may want to 
merge past observations, or other references, to the forecast (or hindcast) to 
compute the indicator. If the forecast simulation doesn't cover the required
period because it is initialized too early (e.g.: Initialization on November
1st the forecast covers until the beginning of June next year), a climatology
(or other references) could be added at the end of the forecast lead time to 
cover the desired period (e.g.: until the end of summer).
}
\details{
This function is created to merge observations and forecasts, known as the 
‘blending’ strategy (see references). The basis for this strategy is that the 
predictions are progressively replaced with observational data as soon as they 
become available (i.e., when entering the indicator definition period). This 
key strategy aims to increase users’ confidence in the reformed predictions.
}
\examples{
data_dates <- c(seq(as.Date("01-07-1993", "\%d-\%m-\%Y", tz = 'UTC'),
                   as.Date("01-12-1993","\%d-\%m-\%Y", tz = 'UTC'), "day"),
               seq(as.Date("01-07-1994", "\%d-\%m-\%Y", tz = 'UTC'),
                   as.Date("01-12-1994","\%d-\%m-\%Y", tz = 'UTC'), "day"))
dim(data_dates) <- c(time = 154, sdate = 2)
data <- NULL
data$data <- array(1:(2*154*2), c(time = 154, sdate = 2, member = 2))
data$attrs$Dates<- data_dates
class(data) <- 's2dv_cube'
ref_dates <- seq(as.Date("01-01-1993", "\%d-\%m-\%Y", tz = 'UTC'),
                as.Date("01-12-1994","\%d-\%m-\%Y", tz = 'UTC'), "day")
dim(ref_dates) <- c(time = 350, sdate = 2)
ref <- NULL
ref$data <- array(1001:1700, c(time = 350, sdate = 2))
ref$attrs$Dates <- ref_dates
class(ref) <- 's2dv_cube'
new_data <- CST_MergeRefToExp(data1 = ref, data2 = data, 
                             start1 = list(21, 6), end1 = list(30, 6),
                             start2 = list(1, 7), end2 = list(21, 9))

}
\references{
Chou, C., R. Marcos-Matamoros, L. Palma Garcia, N. Pérez-Zanón, 
M. Teixeira, S. Silva, N. Fontes, A. Graça, A. Dell'Aquila, S. Calmanti and 
N. González-Reviriego (2023). Advanced seasonal predictions for vine 
management based on bioclimatic indicators tailored to the wine sector. 
Climate Services, 30, 100343, \doi{10.1016/j.cliser.2023.100343}.
}
