% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRingToProfile.R
\name{addRingFromProfile}
\alias{addRingFromProfile}
\title{Add ring to pith to bark profile from profile plot}
\usage{
addRingFromProfile(n = 1, densProfile)
}
\arguments{
\item{n}{Number of rings to add}

\item{densProfile}{Density profile}
}
\value{
Corrected density profile with new ring(s) added and blue bar in plot of added ring
}
\description{
Add ring to pith to bark profile from profile plot
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

endPath <- c(472, 284) # manual
# not run - endPath <- locatePathEnd(im_dens, pith_coord) # using the image

path <- extractProfile(im_dens, image_info, pith_coord, endPath, k = 2, r = 5, threshold = 0.002)

plotProfile(path)
newPath <- addRingFromProfile(n = 1, path)

}
