\name{Efficacy_test}
\alias{Efficacy_test}

\title{
Test to compare efficacy of two models for a percentage of misclassified events
}
\description{Test to compare the efficacy of two markers for paired or unpaired cases
}
\usage{Efficacy_test( paired, Prob1,Prob2,yt1,yt2,z)

}

\arguments{
\item{paired}{if sample is paired 1 else 0
}
 \item{Prob1}{A vector with the event probability values provided by the biomarker 1
}
\item{yt1}{A vector with the actual event values for the biomarker 1
}
\item{Prob2}{A vector with the event probability values provided by the biomarker 2
}
\item{yt2}{A vector with the actual event values for the biomarker 2
}
\item{z}{The misclassification rate at which the effectiveness of the marker will be estimated.
}
}
\details{
Prob1 and Prob2 must be numeric vectors with values between 0 and 1, yt1 and yt2 numeric vectors with dichotomic values 0/1 and z a numeric value between 0 and 100. in a case of a paired comparison, yt1 and yt2 must be the same vector.
}
\value{

The returned results of a test.
\item{Efficacy_test}{It gives the result of the comparison test between markers in terms of efficacy}
}
\author{Maria Escorihuela, Luis Mariano Esteban, Gerardo Sanz, Angel Borque
}

\examples{
###We generate a marker to serve as an example
Prob1<-c(rnorm(10000,0.4,0.1),rnorm(10000,0.5,0.05))
Prob2<-c(rnorm(10000,0.4,0.1),rnorm(10000,0.5,0.05))
yt1<-rep(c(0,1),c(10000,10000))
yt2<-rep(c(0,1),c(10000,10000))
#We choose a rate of 10\% for misclassified events.
##For a paired test

Efficacy_test(paired=1,Prob1,Prob2,yt1,yt2,z=10)

##For a unpaired test

Efficacy_test(paired=0,Prob1,Prob2,yt1,yt2,z=10)
}

\keyword{misc}
\keyword{clinical utility}


