% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{QuadForm-class}
\alias{QuadForm-class}
\alias{.QuadForm}
\alias{QuadForm}
\alias{name,QuadForm-method}
\alias{allow_complex,QuadForm-method}
\alias{to_numeric,QuadForm-method}
\alias{validate_args,QuadForm-method}
\alias{sign_from_args,QuadForm-method}
\alias{dim_from_args,QuadForm-method}
\alias{is_atom_convex,QuadForm-method}
\alias{is_atom_concave,QuadForm-method}
\alias{is_atom_log_log_convex,QuadForm-method}
\alias{is_atom_log_log_concave,QuadForm-method}
\alias{is_incr,QuadForm-method}
\alias{is_decr,QuadForm-method}
\alias{is_quadratic,QuadForm-method}
\alias{is_pwl,QuadForm-method}
\alias{.grad,QuadForm-method}
\title{The QuadForm class.}
\usage{
QuadForm(x, P)

\S4method{name}{QuadForm}(x)

\S4method{allow_complex}{QuadForm}(object)

\S4method{to_numeric}{QuadForm}(object, values)

\S4method{validate_args}{QuadForm}(object)

\S4method{sign_from_args}{QuadForm}(object)

\S4method{dim_from_args}{QuadForm}(object)

\S4method{is_atom_convex}{QuadForm}(object)

\S4method{is_atom_concave}{QuadForm}(object)

\S4method{is_atom_log_log_convex}{QuadForm}(object)

\S4method{is_atom_log_log_concave}{QuadForm}(object)

\S4method{is_incr}{QuadForm}(object, idx)

\S4method{is_decr}{QuadForm}(object, idx)

\S4method{is_quadratic}{QuadForm}(object)

\S4method{is_pwl}{QuadForm}(object)

\S4method{.grad}{QuadForm}(object, values)
}
\arguments{
\item{x}{An \linkS4class{Expression} or numeric vector.}

\item{P}{An \linkS4class{Expression}, numeric matrix, or vector.}

\item{object}{A \linkS4class{QuadForm} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}
}
\description{
This class represents the quadratic form \eqn{x^T P x}
}
\section{Methods (by generic)}{
\itemize{
\item \code{name(QuadForm)}: The name and arguments of the atom.

\item \code{allow_complex(QuadForm)}: Does the atom handle complex numbers?

\item \code{to_numeric(QuadForm)}: Returns the quadratic form.

\item \code{validate_args(QuadForm)}: Checks the dimensions of the arguments.

\item \code{sign_from_args(QuadForm)}: Returns the sign (is positive, is negative) of the atom.

\item \code{dim_from_args(QuadForm)}: The dimensions of the atom.

\item \code{is_atom_convex(QuadForm)}: Is the atom convex?

\item \code{is_atom_concave(QuadForm)}: Is the atom concave?

\item \code{is_atom_log_log_convex(QuadForm)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(QuadForm)}: Is the atom log-log concave?

\item \code{is_incr(QuadForm)}: Is the atom weakly increasing in the argument \code{idx}?

\item \code{is_decr(QuadForm)}: Is the atom weakly decreasing in the argument \code{idx}?

\item \code{is_quadratic(QuadForm)}: Is the atom quadratic?

\item \code{is_pwl(QuadForm)}: Is the atom piecewise linear?

\item \code{.grad(QuadForm)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{x}}{An \linkS4class{Expression} or numeric vector.}

\item{\code{P}}{An \linkS4class{Expression}, numeric matrix, or vector.}
}}

