% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{OneHotEncoder.fit}
\alias{OneHotEncoder.fit}
\title{OneHotEncoder.fit
fits an OneHotEncoder object}
\usage{
OneHotEncoder.fit(X)
}
\arguments{
\item{X}{A matrix or data.frame, which can include NA}
}
\value{
Returns an object of S4 class OneHotEncoder
}
\description{
OneHotEncoder.fit
fits an OneHotEncoder object
}
\examples{
# matrix input
X1 <- matrix(c(0, 1, 0, 1, 0, 1, 2, 0, 3, 0, 1, 2),c(4,3),byrow=FALSE)
oenc <- OneHotEncoder.fit(X1)
z <- transform(oenc,X1,sparse=TRUE)
# return a sparse matrix
print(z)

# data.frame
X2 <- cbind(data.frame(X1),X4=c('a','b','d',NA),X5=factor(c(1,2,3,1)))
oenc <- OneHotEncoder.fit(X2)
z <- transform(oenc,X2,sparse=FALSE)
# return a dense matrix
print(z)
}

