% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CausCor.R
\name{filter_cc}
\alias{filter_cc}
\title{Make list of A-B pair causal correlations}
\usage{
filter_cc(
  a_mat,
  b_mat,
  a_category,
  b_category,
  min_cor,
  min_r2,
  min_sample,
  max_sample = ncol(a_mat) - 1,
  direction = T
)
}
\arguments{
\item{a_mat}{Matrix of measurements of A for each sample.}

\item{b_mat}{Matrix of measurements of B for each sample.}

\item{a_category}{Category name of A.}

\item{b_category}{Category name of B.}

\item{min_cor}{Minimum spearman correlation coefficient.}

\item{min_r2}{Minimum R2 score.}

\item{min_sample}{Minimum number of samples.}

\item{max_sample}{Maximum number of samples. The default is the total
number of samples.}

\item{direction}{Extract only directional associations where a change
in category A causes a change in category B. The default is True.}
}
\description{
Make list of A-B pair causal correlations
}
