% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelTextualUI.R
\name{modelTextualUI}
\alias{modelTextualUI}
\title{Edit textual RsNLME model from Shiny GUI}
\usage{
modelTextualUI(baseModel, initpml, data, modelName = "PKPDmodel")
}
\arguments{
\item{baseModel}{The model object from where the information is recovered.}

\item{initpml}{Initial PML model file to be edited. Overrides
\code{baseModel@statements}, if presented.}

\item{data}{Input data frame.
Overrides \code{baseModel@inputData}, if presented.}

\item{modelName}{Name of the model; if \code{missing}, named as 'PKPDmodel'.
Overrides \code{baseModel@modelInfo@modelName}, if presented.}
}
\value{
A model object of class \code{NlmePmlModel}
}
\description{
Shiny application to update RsNLME model from Shiny GUI and directly edit PML statements using Ace editor. Syntax and semantic check is performed
by TDL executable (if presented). The Shiny application also allows adding input options and column mappings from Shiny GUI.
}
\examples{
if (interactive()) {
model <- modelBuilderUI(data = Certara.RsNLME::pkData, modelName = "PK_Model")

model <- modelTextualUI(baseModel = model)
}

}
