add_descrXpose <- function(summary) {
  summary <-
    dplyr::mutate(
      summary,
      descr = dplyr::case_when(
        label == "software" ~ "Software",
        label == "version" ~ "Software version",
        label == "file" ~ "Run file",
        label == "run" ~ "Run number",
        label == "dir" ~ "Run directory",
        label == "ref" ~ "Reference model",
        label == "probn" ~ "Problem number",
        label == "timestart" ~ "Run start time",
        label == "timestop" ~ "Run stop time",
        label == "descr" ~ "Run description",
        label == "label" ~ "Run label",
        label == "data" ~ "Input data",
        label == "nobs" ~ "Number of observations",
        label == "nind" ~ "Number of individuals",
        label == "nsim" ~ "Number of simulations",
        label == "simseed" ~ "Simulation seed",
        label == "subroutine" ~ "ADVAN",
        label == "runtime" ~ "Estimation runtime",
        label == "covtime" ~ "Covariance step runtime",
        label == "term" ~ "Termination message",
        label == "warnings" ~ "Run warnings",
        label == "errors" ~ "Run errors",
        label == "nsig" ~ "Number of significant digits",
        label == "condn" ~ "Condition number",
        label == "nesample" ~ "Number of ESAMPLE",
        label == "esampleseed" ~ "ESAMPLE seed number",
        label == "ofv" ~ "Objective function value",
        label == "method" ~ "Estimation method",
        label == "epsshk" ~ "Epsilon shrinkage",
        label == "etashk" ~ "Eta shrinkage"
      )
    )

  summary
}
