read_dataFile <- function(dataFile) {
  inputColnames <- gsub(
    "^(X\\.\\.)|(##)",
    "",
    utils::read.csv(
      dataFile,
      nrows = 1,
      colClasses = "character",
      header = FALSE,
      strip.white = TRUE
    )
  )

  optionalUnits <-
    utils::read.csv(
      dataFile,
      skip = 1,
      nrows = 1,
      colClasses = "character",
      header = FALSE,
      strip.white = TRUE
    )

  if (grepl("^(#@)", optionalUnits[1, 1])) {
    unitsPresent <- TRUE
    optionalUnits[1, 1] <- gsub("^(#@)", "", optionalUnits[1, 1])
    colnames(optionalUnits) <- inputColnames
    optionalUnits <- optionalUnits[colnames(optionalUnits) == ""]
  } else {
    unitsPresent <- FALSE
  }

  if (requireNamespace("data.table", quietly = TRUE)) {
    input <- data.table::fread(
      file = dataFile,
      skip = 1 + unitsPresent,
      header = FALSE,
      data.table = FALSE
    ) %>%
      tibble::tibble()
  } else if (requireNamespace("readr", quietly = TRUE)) {
    input <- readr::read_csv(
      dataFile,
      skip = 1 + unitsPresent,
      col_names = FALSE,
      col_types = readr::cols(.default = readr::col_character())
    )
    suppressMessages(input <- readr::type_convert(input))
  } else {
    input <-
      utils::read.csv(dataFile,
                      skip = 1 + unitsPresent,
                      header = FALSE
      ) %>%
      tibble::tibble()
  }

  # removing empty column names to prevent dplyr crash
  colnames(input) <- inputColnames
  input <- input[, inputColnames != ""]

  list(input = input, unitsPresent = unitsPresent, optionalUnits = optionalUnits)
}
