% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prmNlme.R
\name{get_prmNlme}
\alias{get_prmNlme}
\title{Access NLME model parameter estimates}
\usage{
get_prmNlme(
  xpdb,
  .problem = 1,
  .subprob = 0,
  .method = NULL,
  digits = 6,
  show_all = FALSE,
  level = 0.95
)
}
\arguments{
\item{xpdb}{An \code{xpose} data base object from which the model output
file data will be extracted. Only objects generated by \code{xposeNlme} are supported.}

\item{.problem}{The problem to be used.}

\item{.subprob}{The subproblem to be used.}

\item{.method}{The estimation method to be used.}

\item{digits}{Integer specifying the number of significant digits to be displayed.}

\item{show_all}{Logical specifying whether the 0 off-diagonal omega elements
should be removed from the output or not.}

\item{level}{Numeric specifying confidence level to compute confidence intervals,
which are calculated based on Student’s t distribution.}
}
\value{
A tibble for single problem/subproblem.
}
\description{
Access model parameter estimates from an xpdb object generated by
xposeNlme.
}
\examples{
# Store the parameter table
prm <- get_prmNlme(xpdb_ex_Nlme)

# Set the desired number of significant digits to display results

# Note: To have results displayed in the number of significant digits
#  specified in the digits argument, one needs to make sure that
#  the value of pillar.sigfig option (default value is 3) is greater
#  than or equal to this specified value.

options(pillar.sigfig = 6)
get_prmNlme(xpdb_ex_Nlme, digits = 4)

}
\seealso{
\code{\link{xposeNlme}}
}
