% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_adjacency_matrix_to_costmatrix.r
\name{convert_adjacency_matrix_to_costmatrix}
\alias{convert_adjacency_matrix_to_costmatrix}
\title{Converts an adjacency matrix to a costmatrix}
\usage{
convert_adjacency_matrix_to_costmatrix(adjacency_matrix)
}
\arguments{
\item{adjacency_matrix}{A labelled square matrix with zeroes denoting non-adjacencies and ones denoting adjacencies.}
}
\value{
An object of class \code{costMatrix}.
}
\description{
Takes an adjacency matrix as input and returns the corresponding costmatrix.
}
\details{
This function is intended for internal use, but as it also generalizes to solving a general graph theory problem - generating a distance matrix corresponding to each shortest path between vertices of a connected graph represented as an adjacency matrix - it is made available explicitly here.

The process is best understood with an example. Imagine we have a graph like this:

\preformatted{  0-1-2
  |
  3}

I.e., we have four labelled vertices, 0-3, and three edges (connections) between them:

\preformatted{  0-1
  1-2
  0-3}

Note: here we assume symmetry, 0-1 = 1-0.

Graphs like this can be explicitly captured as adjacency matrices, where a one denotes two vertices are "adjacent" (connected by an edge) and a zero that they are not.

\preformatted{    _________________
    | 0 | 1 | 2 | 3 |
---------------------
| 0 | 0 | 1 | 0 | 1 |
---------------------
| 1 | 1 | 0 | 1 | 0 |
---------------------
| 2 | 0 | 1 | 0 | 0 |
---------------------
| 3 | 1 | 0 | 0 | 0 |
---------------------}

But what such matrices do not tell us is how far every vertex-to-vertex path is in terms of edge counts. E.g., the path length from vertex 3 to vertex 2.

This function simply takes the adjacency matrix and returns the corresponding costmatrix, corresponding to every minimum vertex-to-vertex path length.
}
\examples{

# Build the example adjacency matrix for the graph above:
adjacency_matrix <- matrix(
  data = c(
    0, 1, 0, 1,
    1, 0, 1, 0,
    0, 1, 0, 0,
    1, 0, 0, 0
  ),
  nrow = 4,
  ncol = 4,
  dimnames = list(0:3, 0:3)
)

# Convert this to a costmatrix:
convert_adjacency_matrix_to_costmatrix(
  adjacency_matrix = adjacency_matrix
)

}
\seealso{
\link{convert_state_tree_to_adjacency_matrix}, \link{locate_bracket_positions}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
