% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_restricted_compositions.r
\name{permute_restricted_compositions}
\alias{permute_restricted_compositions}
\title{Permute all ways to place n items into m bins}
\usage{
permute_restricted_compositions(n, m_labels, allow_zero = FALSE)
}
\arguments{
\item{n}{A positive integer.}

\item{m_labels}{A character vector of labels for m.}

\item{allow_zero}{A logical indicating whether or not each bin should (\code{TRUE}) or should not (\code{FALSE}) be allowed to be zero.}
}
\value{
A matrix where each row is a unique restricted composition of n and each column is a labelled bin.
}
\description{
Given a positive integer, n, and a number of bins (m), permutes all possible compositions.
}
\details{
Every way that an integer (\code{n}) can be divided up into \code{m} bins can be permuted using a restricted version of the mathematical concept of compositions. In practice this function is designed to distribute the states for \code{n} tips across \code{m} states (e.g., with \link{permute_tipstates}), but many other uses are conceivable and hence this is included here as a general function.

This algorithm reuses code from the \code{multicool} (Curran et al. 2021) and \code{partitions} (Hankin 2006) packages.

The number of restricted compositions is given by the k-dimensional extension of triangular numbers (Baumann 2019):

\itemize{
  \item{If \code{allow_zero = TRUE}, the binomial coefficient, n choose k, where n = \code{n + m} - 1 and k = \code{m}.}
  \item{If \code{allow_zero = FALSE}, the binomial coefficient, n choose k, where n = \code{n} - 1 and k = \code{m}.}
}
}
\examples{

# Permute all the ways eight can be assigned to four bins (A, C, G, T),
# with each bin assigned at least one:
permute_restricted_compositions(
  n = 8,
  m_labels = c("A", "C", "G", "T"),
  allow_zero = FALSE
)

}
\references{
Baumann, M. H., 2019. Die k-dimensionale Champagnerpyramide. Mathematische Semesterberichte, 66, 89-100.

Curran, J., Williams, A., Kelleher, J. and Barber, D., 2021. multicool: Permutations of Multisets in Cool-Lex Order. R package version 0.1-12. https://CRAN.R-project.org/package=multicool.

Hankin, R. K. S., 2006. Additive integer partitions in R. \emph{Journal of Statistical Software, Code Snippets}, \bold{16}, 1.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
