% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-1-dim-reduction.R
\name{plot_feature_stability_ecs_facet}
\alias{plot_feature_stability_ecs_facet}
\title{Feature Stability - EC Consistency Facet Plot}
\usage{
plot_feature_stability_ecs_facet(
  feature_object_list,
  resolution,
  n_facet_cols = 3,
  point_size = 0.3
)
}
\arguments{
\item{feature_object_list}{An object or a concatenation of objects returned
by the \code{assess_feature_stability} method}

\item{resolution}{The resolution value for which the ECS will be extracted.}

\item{n_facet_cols}{The number of facet's columns.}

\item{point_size}{The size of the points displayed on the plot.}
}
\value{
A ggplot2 object
}
\description{
Display a facet of plots where each subpanel is associated with
a feature set and illustrates the distribution of the EC consistency score
over the UMAP embedding.
}
\examples{
set.seed(2024)
# create an artificial expression matrix
expr_matrix <- matrix(
    c(runif(100 * 10), runif(50 * 10, min = 3, max = 4)),
    nrow = 150, byrow = TRUE
)
rownames(expr_matrix) <- as.character(1:150)
colnames(expr_matrix) <- paste("feature", 1:10)

feature_stability_result <- assess_feature_stability(
    data_matrix = t(expr_matrix),
    feature_set = colnames(expr_matrix),
    steps = 5,
    feature_type = "feature_name",
    resolution = c(0.1, 0.5, 1),
    n_repetitions = 10,
    clustering_algorithm = 1
)
plot_feature_stability_ecs_facet(
    feature_stability_result,
    0.5,
    point_size = 2
)
}
