% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariationTable.R
\name{VariationTable}
\alias{VariationTable}
\title{Effects of infinitesimal changes in CoDa models}
\usage{
VariationTable(
  object,
  Xvar,
  Xdir,
  obs = 1,
  inc_size = 0.1,
  inc_rate = NULL,
  Ytotal = 1,
  normalize_Xdir = TRUE
)
}
\arguments{
\item{object}{an object of class "lmCoDa"}

\item{Xvar}{a character indicating the name of the explanatory variable that changes}

\item{Xdir}{either character or numeric, to indicate the direction in which Xvar should change
\itemize{
\item when character this should be one of the components of X, in which case the direction is the corresponding vertex of the simplex
\item when numeric this argument is coerced to a unit vector in the simplex
\item (when Xvar refers to a scalar variable this argument is ignored)
}}

\item{obs}{a numeric indicating the observation used for the scenario}

\item{inc_size}{a numeric indicating the distance between each point in the scenario of X}

\item{inc_rate}{a numeric that can be used as a parameterization of the step size}

\item{Ytotal}{a numeric indicating the total of Y}

\item{normalize_Xdir}{a logical, if \code{TRUE} the direction \code{Xdir} scaled to have an Aitchison norm of 1, allowing to interpret \code{inc_size} as the Aitchison distance}
}
\value{
data.frame
}
\description{
This function allows to evaluate how a change in an explanatory variables
impacts the response variable in a CoDa regression model.
The changes are calculated based from the approximate formal presented
in Dargel and Thomas-Agnan (2024).
Changes in the response variables are provided as data.frame and the
underlying changes in the explanatory variable are given as attributes.
}
\examples{

# XY-compositional model
res <- lmCoDa(
  ilr(cbind(left, right, extreme_right)) ~
  ilr(cbind(Educ_BeforeHighschool, Educ_Highschool, Educ_Higher)),
  data =  head(election, 20))

# Focus on changes in the education composition
educ_comp <- "cbind(Educ_BeforeHighschool, Educ_Highschool, Educ_Higher)"

# ... changes towards a summit towards a summit (higher share of people with lower education)
VariationTable(res, educ_comp, Xdir = "Educ_BeforeHighschool")

# ... same changes using a compositional vector as direction
VariationTable(res, educ_comp, Xdir = c(.5,.25,.25))

# ... changes in a more general direction and for a different observation
VariationTable(res, educ_comp, Xdir = c(.35,.45,.10), obs = 2)

}
\references{
\itemize{
\item Dargel, Lukas and Christine Thomas-Agnan, “Pairwise share ratio interpretations of compositional regression models”, Computational Statistics & Data Analysis 195 (2024), p. 107945
}
}
\author{
\itemize{
\item Lukas Dargel
\item Rodrigue Nasr
}
}
