% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_generic.R
\name{plot.classCoMiRe}
\alias{plot.classCoMiRe}
\title{CoMiRe plot}
\usage{
\method{plot}{classCoMiRe}(
  x,
  y,
  xobs,
  mcmc,
  J = 10,
  H = 10,
  a = NULL,
  max.x = max(xobs),
  bandwidth = 20,
  x.grid = NULL,
  xlim = c(0, max(xobs)),
  ylim = c(0, 1),
  xlab = "x",
  alpha = 0.05,
  risk = TRUE,
  bmd = TRUE,
  level,
  oneevery = 20,
  ...
)
}
\arguments{
\item{x}{the output of \code{comire.gibbs}, an object of the \code{classCoMiRe} class.}

\item{y}{numeric vector for the response used in \code{comire.gibbs}.}

\item{xobs}{numeric vector for the covariate relative to the dose of exposure used in \code{comire.gibbs}.}

\item{mcmc}{a list giving the MCMC parameters.}

\item{J}{parameter controlling the number of elements of the I-spline basis}

\item{H}{total number of components in the mixture at \eqn{x_0}.}

\item{a}{optional threshold of clinical interest for the response variable.}

\item{max.x}{maximum value allowed for x.}

\item{bandwidth}{the kernel bandwidth smoothing parameter for the \code{post.pred.check} plot.}

\item{x.grid}{optional numerical vector giving the actual values of the grid for x for plotting the additional risk function. If \eqn{x.gird} is not provided, standard grids are automatically used.}

\item{xlim, ylim}{numeric vectors of length 2, giving the x and y coordinates ranges for the plot.}

\item{xlab}{the title of the x axis.}

\item{alpha}{level of the credible bands, default 0.05}

\item{risk}{if \code{TRUE} the additional risk plot via \code{riskplot} is computed.}

\item{bmd}{if \code{TRUE} the benchmark dose plot via \code{bmd.plot} is computed.}

\item{level}{if \code{bmd=TRUE}, dose levels of interest for BMD plot.}

\item{oneevery}{integer number representing how many MCMC draws to plot in the posterior predictive check. It draws one sample every \code{oneevery}.}

\item{...}{additional arguments to be passed.}
}
\value{
If \code{a=NULL} returns only \code{betaplot} otherwise, if \code{risk=FALSE} and 
\code{bmd=FALSE} returns a list containing \code{betaplot} (which is automatically plotted) 
and \code{post.pred.check} plot. Finally, if \code{a} is provided, \code{risk=TRUE} and \code{bmd=TRUE}
returns a list with \code{betaplot}, \code{post.pred.check}, \code{riskplot} and \code{bmd.plot}.
}
\description{
An S3 plot method for an object of \code{classCoMiRe} class.
}
\details{
The output is a list of 
\code{ggplot2} plots containing the result of the \code{betaplot} function and, if the threshold \code{a} is provided, of 
\code{post.pred.check}, \code{riskplot}, \code{bmd.plot}.
}
\author{
Antonio Canale, Arianna Falcioni
}
