% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCharacteristics.R
\name{plotCharacteristics}
\alias{plotCharacteristics}
\title{Create a ggplot from the output of summariseCharacteristics.}
\usage{
plotCharacteristics(
  result,
  plotType = "barplot",
  facet = NULL,
  colour = NULL,
  style = NULL,
  plotStyle = lifecycle::deprecated()
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{plotType}{Either \code{barplot}, \code{scatterplot} or \code{boxplot}. If \code{barplot}
or \code{scatterplot} subset to just one estimate.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character, this
may be either the name of a built-in style (see \code{plotStyle()}), or a path to
a \code{.yml} file that defines a custom style. If NULL, the function will use the
explicit default style, unless a global style option is set (see
\code{setGlobalPlotOptions()}), or a _brand.yml file is present (in that order).
Refer to the package vignette on styles to learn more.}

\item{plotStyle}{deprecated.}
}
\value{
A ggplot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCohortCharacteristics()

results <- summariseCharacteristics(
  cohort = cdm$cohort1,
  ageGroup = list(c(0, 19), c(20, 39), c(40, 59), c(60, 79), c(80, 150)),
  tableIntersectCount = list(
    tableName = "visit_occurrence", window = c(-365, -1)
  ),
  cohortIntersectFlag = list(
    targetCohortTable = "cohort2", window = c(-365, -1)
  )
)

results |>
  filter(
    variable_name == "Cohort2 flag -365 to -1", estimate_name == "percentage"
  ) |>
  plotCharacteristics(
    plotType = "barplot",
    colour = "variable_level",
    facet = c("cdm_name", "cohort_name")
  )

results |>
  filter(variable_name == "Age", estimate_name == "mean") |>
  plotCharacteristics(
    plotType = "scatterplot",
    facet = "cdm_name"
  )

results |>
  filter(variable_name == "Age", group_level == "cohort_1") |>
  plotCharacteristics(
    plotType = "boxplot",
    facet = "cdm_name",
    colour = "cohort_name"
  )

}
}
