% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTemporalSymmetry.R
\name{plotTemporalSymmetry}
\alias{plotTemporalSymmetry}
\title{A plot for the temporal symmetry of cohorts.}
\usage{
plotTemporalSymmetry(
  result,
  plotTitle = NULL,
  labs = c("Time (months)", "Individuals (N)"),
  xlim = c(-12, 12),
  colours = c("blue", "red"),
  scales = "free"
)
}
\arguments{
\item{result}{Table output from summariseTemporalSymmetry.}

\item{plotTitle}{Title of the plot, if NULL no title will be plotted.}

\item{labs}{Axis labels for the plot.}

\item{xlim}{Limits for the x axis of the plot.}

\item{colours}{Colours for both parts of the plot, pre- and post- time 0.}

\item{scales}{Whether to set free y scales for the facet wrap when there are
multiple plots (i.e. each plot has its own scaled y axis) or set them equal
for all. Only accepts "free" for the former and "fixed" for the latter.}
}
\value{
A plot for the temporal symmetry of cohorts.
}
\description{
It provides a ggplot of the temporal symmetry of two or more cohorts.
}
\examples{
\donttest{
library(CohortSymmetry)
cdm <- mockCohortSymmetry()
cdm <- generateSequenceCohortSet(cdm = cdm,
                                 indexTable = "cohort_1",
                                 markerTable = "cohort_2",
                                 name = "joined_cohort")
temporal_symmetry <- summariseTemporalSymmetry(cohort = cdm$joined_cohort)
plotTemporalSymmetry(result = temporal_symmetry)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
